/*
 * Decompiled with CFR 0.152.
 */
package jeresources.entry;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import jeresources.api.drop.LootDrop;
import jeresources.registry.DungeonRegistry;
import jeresources.util.LootFunctionHelper;
import jeresources.util.LootTableHelper;
import mezz.jei.api.recipe.IFocus;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.storage.loot.ItemLootEntry;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.StandaloneLootEntry;
import net.minecraft.world.storage.loot.TableLootEntry;
import net.minecraftforge.items.ItemHandlerHelper;

public class DungeonEntry {
    private Set<LootDrop> drops = new TreeSet<LootDrop>();
    private String name;
    private int maxStacks;
    private int minStacks;

    public DungeonEntry(String name, LootTable lootTable) {
        this.name = name;
        float[] tmpMinStacks = new float[]{0.0f};
        float[] tmpMaxStacks = new float[]{0.0f};
        LootTableManager manager = LootTableHelper.getManager();
        this.handleTable(lootTable, manager, tmpMinStacks, tmpMaxStacks);
        this.minStacks = MathHelper.func_76141_d((float)tmpMinStacks[0]);
        this.maxStacks = MathHelper.func_76141_d((float)tmpMaxStacks[0]);
    }

    private void handleTable(LootTable lootTable, LootTableManager manager, float[] tmpMinStacks, float[] tmpMaxStacks) {
        LootTableHelper.getPools(lootTable).forEach(pool -> {
            tmpMinStacks[0] = tmpMinStacks[0] + (float)LootFunctionHelper.getMin(pool.getRolls());
            tmpMaxStacks[0] = tmpMaxStacks[0] + (float)(LootFunctionHelper.getMax(pool.getRolls()) + LootFunctionHelper.getMax(pool.getBonusRolls()));
            float totalWeight = LootTableHelper.getLootEntries(pool).stream().filter(entry -> entry instanceof StandaloneLootEntry).map(entry -> (StandaloneLootEntry)entry).mapToInt(entry -> entry.field_216158_e).sum();
            LootTableHelper.getLootEntries(pool).stream().filter(entry -> entry instanceof ItemLootEntry).map(entry -> (ItemLootEntry)entry).map(entry -> new LootDrop(entry.field_186368_a, (float)entry.field_216158_e / totalWeight, entry.field_216160_g)).forEach(this.drops::add);
            LootTableHelper.getLootEntries(pool).stream().filter(entry -> entry instanceof TableLootEntry).map(entry -> (TableLootEntry)entry).map(entry -> manager.func_186521_a(entry.field_186371_a)).forEach(table -> this.handleTable((LootTable)table, manager, tmpMinStacks, tmpMaxStacks));
        });
    }

    public boolean containsItem(ItemStack itemStack) {
        return this.drops.stream().anyMatch(drop -> drop.item.func_77969_a(itemStack));
    }

    public String getName() {
        String name = DungeonRegistry.categoryToLocalKeyMap.get(this.name);
        return name == null ? this.name : name;
    }

    public List<ItemStack> getItemStacks() {
        return this.getItemStacks(null);
    }

    public List<ItemStack> getItemStacks(IFocus<ItemStack> focus) {
        return this.drops.stream().map(drop -> drop.item).filter(stack -> focus == null || ItemStack.func_77989_b((ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)((ItemStack)focus.getValue()).func_190916_E()), (ItemStack)((ItemStack)focus.getValue()))).collect(Collectors.toList());
    }

    public int getMaxStacks() {
        return this.maxStacks;
    }

    public int getMinStacks() {
        return this.minStacks;
    }

    public LootDrop getChestDrop(ItemStack ingredient) {
        return this.drops.stream().filter(drop -> ItemStack.func_179545_c((ItemStack)drop.item, (ItemStack)ingredient)).findFirst().orElse(null);
    }
}

