/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.bindings;

import dev.latvian.kubejs.block.MaterialJS;
import dev.latvian.kubejs.block.MaterialListJS;
import dev.latvian.kubejs.block.predicate.BlockEntityPredicate;
import dev.latvian.kubejs.block.predicate.BlockIDPredicate;
import dev.latvian.kubejs.block.predicate.BlockPredicate;
import dev.latvian.kubejs.docs.ID;
import dev.latvian.kubejs.docs.MinecraftClass;
import dev.latvian.kubejs.util.UtilsJS;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockWrapper {
    private Map<String, Direction> facingMap;

    public Map<String, MaterialJS> getMaterial() {
        return MaterialListJS.INSTANCE.map;
    }

    public BlockIDPredicate id(@ID String id) {
        return new BlockIDPredicate(id);
    }

    public BlockIDPredicate id(@ID String id, Map<String, Object> properties) {
        BlockIDPredicate b = this.id(id);
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            b = b.with(entry.getKey(), entry.getValue().toString());
        }
        return b;
    }

    public BlockEntityPredicate entity(@ID String id) {
        return new BlockEntityPredicate(id);
    }

    public BlockPredicate custom(BlockPredicate predicate) {
        return predicate;
    }

    public Map<String, Direction> getFacing() {
        if (this.facingMap == null) {
            this.facingMap = new HashMap<String, Direction>(6);
            for (Direction facing : Direction.values()) {
                this.facingMap.put(facing.func_176610_l(), facing);
            }
        }
        return this.facingMap;
    }

    @MinecraftClass
    public Block getBlock(@ID String id) {
        Block b = (Block)ForgeRegistries.BLOCKS.getValue(UtilsJS.getMCID(id));
        return b == null ? Blocks.field_150350_a : b;
    }

    public List<String> getTypeList() {
        ArrayList<String> list = new ArrayList<String>();
        for (ResourceLocation block : ForgeRegistries.BLOCKS.getKeys()) {
            list.add(block.toString());
        }
        return list;
    }
}

