/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.block;

import com.google.gson.JsonObject;
import dev.latvian.kubejs.block.BlockItemBuilder;
import dev.latvian.kubejs.block.BlockJS;
import dev.latvian.kubejs.block.MaterialJS;
import dev.latvian.kubejs.block.MaterialListJS;
import dev.latvian.kubejs.util.BuilderBase;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.util.Direction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraftforge.common.ToolType;

public class BlockBuilder
extends BuilderBase {
    public static BlockBuilder current;
    public MaterialJS material;
    public float hardness;
    public float resistance;
    public float lightLevel;
    public ToolType harvestTool;
    public int harvestLevel;
    public boolean opaque;
    public boolean fullBlock;
    public String renderType;
    public Int2IntOpenHashMap color;
    public final JsonObject textures;
    public String model;
    public BlockItemBuilder itemBuilder;
    public List<VoxelShape> customShape;
    public boolean notSolid;
    public boolean waterlogged;
    public BlockJS block;

    public BlockBuilder(String i) {
        super(i);
        this.material = MaterialListJS.INSTANCE.map.get("wood");
        this.hardness = 0.5f;
        this.resistance = -1.0f;
        this.lightLevel = 0.0f;
        this.harvestTool = null;
        this.harvestLevel = -1;
        this.opaque = true;
        this.fullBlock = false;
        this.renderType = "solid";
        this.color = new Int2IntOpenHashMap();
        this.color.defaultReturnValue(-1);
        this.textures = new JsonObject();
        this.texture(this.id.func_110624_b() + ":block/" + this.id.func_110623_a());
        this.model = this.id.func_110624_b() + ":block/" + this.id.func_110623_a();
        this.itemBuilder = new BlockItemBuilder(i);
        this.itemBuilder.blockBuilder = this;
        this.itemBuilder.parentModel = this.model;
        this.customShape = new ArrayList<VoxelShape>();
        this.notSolid = false;
        this.waterlogged = false;
    }

    @Override
    public String getType() {
        return "block";
    }

    public BlockBuilder material(MaterialJS m) {
        this.material = m;
        return this;
    }

    public BlockBuilder material(String id) {
        return this.material(MaterialListJS.INSTANCE.map.getOrDefault(id, this.material));
    }

    public BlockBuilder hardness(float h) {
        this.hardness = h;
        return this;
    }

    public BlockBuilder resistance(float r) {
        this.resistance = r;
        return this;
    }

    public BlockBuilder unbreakable() {
        this.hardness = -1.0f;
        this.resistance = Float.MAX_VALUE;
        return this;
    }

    public BlockBuilder lightLevel(float light) {
        this.lightLevel = light;
        return this;
    }

    public BlockBuilder harvestTool(ToolType tool, int level) {
        this.harvestTool = tool;
        this.harvestLevel = level;
        return this;
    }

    public BlockBuilder opaque(boolean o) {
        this.opaque = o;
        return this;
    }

    public BlockBuilder fullBlock(boolean f) {
        this.fullBlock = f;
        return this;
    }

    public BlockBuilder renderType(String l) {
        this.renderType = l;
        return this;
    }

    public BlockBuilder color(int index, int c) {
        this.color.put(index, 0xFF000000 | c);
        return this;
    }

    public BlockBuilder texture(String tex) {
        for (Direction direction : Direction.values()) {
            this.textures.addProperty(direction.func_176610_l(), tex);
        }
        this.textures.addProperty("particle", tex);
        return this;
    }

    public BlockBuilder texture(Direction direction, String tex) {
        this.textures.addProperty(direction.func_176610_l(), tex);
        return this;
    }

    public BlockBuilder model(String m) {
        this.itemBuilder.parentModel = this.model = m;
        return this;
    }

    public BlockBuilder item(@Nullable Consumer<BlockItemBuilder> i) {
        if (i == null) {
            this.itemBuilder = null;
        } else {
            i.accept(this.itemBuilder);
        }
        return this;
    }

    public BlockBuilder noItem() {
        return this.item(null);
    }

    public BlockBuilder shapeCube(double x0, double y0, double z0, double x1, double y1, double z1) {
        this.customShape.add(Block.func_208617_a((double)x0, (double)y0, (double)z0, (double)x1, (double)y1, (double)z1));
        return this;
    }

    public BlockBuilder notSolid() {
        this.notSolid = true;
        return this;
    }

    public BlockBuilder waterlogged() {
        this.waterlogged = true;
        return this;
    }

    public Block.Properties createProperties() {
        Block.Properties properties = Block.Properties.func_200945_a((Material)this.material.getMinecraftMaterial());
        properties.func_200947_a(this.material.getSound());
        if (this.resistance >= 0.0f) {
            properties.func_200948_a(this.hardness, this.resistance);
        } else {
            properties.func_200943_b(this.hardness);
        }
        properties.func_200951_a((int)(this.lightLevel * 15.0f));
        if (this.harvestTool != null) {
            properties.harvestTool(this.harvestTool);
        }
        if (this.harvestLevel >= 0) {
            properties.harvestLevel(this.harvestLevel);
        }
        if (this.notSolid) {
            properties.func_226896_b_();
        }
        return properties;
    }
}

