/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.block;

import dev.latvian.kubejs.entity.EntityJS;
import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.player.PlayerEventJS;
import dev.latvian.kubejs.world.BlockContainerJS;
import dev.latvian.kubejs.world.WorldJS;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.world.BlockEvent;

public class BlockDropsEventJS
extends PlayerEventJS {
    public final BlockEvent.HarvestDropsEvent event;
    public List<ItemStackJS> dropList;

    public BlockDropsEventJS(BlockEvent.HarvestDropsEvent e) {
        this.event = e;
    }

    @Override
    public WorldJS getWorld() {
        return this.worldOf(this.event.getWorld());
    }

    @Override
    public EntityJS getEntity() {
        return this.entityOf((Entity)this.event.getHarvester());
    }

    public BlockContainerJS getBlock() {
        return new BlockContainerJS(this.event.getWorld(), this.event.getPos()){

            @Override
            public BlockState getBlockState() {
                return BlockDropsEventJS.this.event.getState();
            }
        };
    }

    public int getFortuneLevel() {
        return this.event.getFortuneLevel();
    }

    public List<ItemStackJS> getDrops() {
        if (this.dropList == null) {
            this.dropList = new ArrayList<ItemStackJS>();
            for (ItemStack stack : this.event.getDrops()) {
                this.dropList.add(ItemStackJS.of(stack));
            }
        }
        return this.dropList;
    }

    public boolean isSilkTouching() {
        return this.event.isSilkTouching();
    }

    public float getDropChance() {
        return this.event.getDropChance();
    }

    public void setDropChance(float dropChance) {
        this.event.setDropChance(dropChance);
    }

    public void addDrop(Object item) {
        ItemStackJS i = ItemStackJS.of(item);
        if (!i.isEmpty()) {
            this.getDrops().add(i);
        }
    }

    public void addDrop(Object item, float chance) {
        if (chance >= 1.0f || this.event.getWorld().func_201674_k().nextFloat() <= chance) {
            this.addDrop(item);
        }
    }

    public ItemStackJS getItem() {
        return ItemStackJS.of(this.event.getHarvester().func_184586_b(Hand.MAIN_HAND));
    }

    public int getItemHarvestLevel(ToolType tool) {
        ItemStack stack = this.event.getHarvester().func_184586_b(Hand.MAIN_HAND);
        return stack.func_77973_b().getHarvestLevel(stack, tool, this.event.getHarvester(), this.event.getState());
    }

    public int getPickaxeLevel() {
        return this.getItemHarvestLevel(ToolType.PICKAXE);
    }

    public int getAxeLevel() {
        return this.getItemHarvestLevel(ToolType.AXE);
    }

    public int getShovelLevel() {
        return this.getItemHarvestLevel(ToolType.SHOVEL);
    }
}

