/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.block;

import dev.latvian.kubejs.KubeJSObjects;
import dev.latvian.kubejs.block.BlockBreakEventJS;
import dev.latvian.kubejs.block.BlockBuilder;
import dev.latvian.kubejs.block.BlockDropsEventJS;
import dev.latvian.kubejs.block.BlockJS;
import dev.latvian.kubejs.block.BlockLeftClickEventJS;
import dev.latvian.kubejs.block.BlockPlaceEventJS;
import dev.latvian.kubejs.block.BlockRightClickEventJS;
import dev.latvian.kubejs.fluid.FluidBuilder;
import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.util.BuilderBase;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class KubeJSBlockEventHandler {
    public void init() {
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Block.class, this::registry);
        MinecraftForge.EVENT_BUS.addListener(this::rightClick);
        MinecraftForge.EVENT_BUS.addListener(this::leftClick);
        MinecraftForge.EVENT_BUS.addListener(this::blockBreak);
        MinecraftForge.EVENT_BUS.addListener(this::blockPlace);
        MinecraftForge.EVENT_BUS.addListener(this::blockDrops);
    }

    private void registry(RegistryEvent.Register<Block> event) {
        Iterator<BuilderBase> iterator = KubeJSObjects.BLOCKS.values().iterator();
        while (iterator.hasNext()) {
            BlockBuilder blockBuilder;
            BlockBuilder.current = blockBuilder = iterator.next();
            blockBuilder.block = new BlockJS(blockBuilder);
            blockBuilder.block.setRegistryName(blockBuilder.id);
            event.getRegistry().register((IForgeRegistryEntry)blockBuilder.block);
        }
        BlockBuilder.current = null;
        for (FluidBuilder fluidBuilder : KubeJSObjects.FLUIDS.values()) {
            fluidBuilder.block = new FlowingFluidBlock(() -> builder.stillFluid, Block.Properties.func_200945_a((Material)Material.field_151586_h).func_200942_a().func_200943_b(100.0f).func_222380_e());
            fluidBuilder.block.setRegistryName(fluidBuilder.id);
            event.getRegistry().register((IForgeRegistryEntry)fluidBuilder.block);
        }
    }

    private void rightClick(PlayerInteractEvent.RightClickBlock event) {
        if (new BlockRightClickEventJS(event).post("block.right_click")) {
            event.setCanceled(true);
        }
    }

    private void leftClick(PlayerInteractEvent.LeftClickBlock event) {
        if (new BlockLeftClickEventJS(event).post("block.left_click")) {
            event.setCanceled(true);
        }
    }

    private void blockBreak(BlockEvent.BreakEvent event) {
        if (new BlockBreakEventJS(event).post("block.break")) {
            event.setCanceled(true);
        }
    }

    private void blockPlace(BlockEvent.EntityPlaceEvent event) {
        if (new BlockPlaceEventJS(event).post("block.place")) {
            event.setCanceled(true);
        }
    }

    private void blockDrops(BlockEvent.HarvestDropsEvent event) {
        if (event.getWorld().func_201670_d()) {
            return;
        }
        BlockDropsEventJS e = new BlockDropsEventJS(event);
        e.post("block.drops");
        if (e.dropList != null) {
            event.getDrops().clear();
            for (ItemStackJS stack : e.dropList) {
                event.getDrops().add(stack.getItemStack());
            }
        }
    }
}

