/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.block;

import dev.latvian.kubejs.docs.ID;
import dev.latvian.kubejs.event.EventJS;
import dev.latvian.kubejs.script.ScriptType;
import dev.latvian.kubejs.util.UtilsJS;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class MissingMappingEventJS<T extends IForgeRegistryEntry<T>>
extends EventJS {
    private final RegistryEvent.MissingMappings<T> event;
    private final Function<ResourceLocation, T> valueProvider;

    public MissingMappingEventJS(RegistryEvent.MissingMappings<T> e, Function<ResourceLocation, T> v) {
        this.event = e;
        this.valueProvider = v;
    }

    private void findMapping(@ID String key, Consumer<RegistryEvent.MissingMappings.Mapping<T>> callback) {
        ResourceLocation k = UtilsJS.getMCID(key);
        for (RegistryEvent.MissingMappings.Mapping mapping : this.event.getAllMappings()) {
            if (!mapping.key.equals((Object)k)) continue;
            callback.accept(mapping);
            return;
        }
    }

    public void remap(@ID String key, @ID String value) {
        this.findMapping(key, mapping -> {
            ResourceLocation idTo = UtilsJS.getMCID(value);
            IForgeRegistryEntry to = (IForgeRegistryEntry)this.valueProvider.apply(idTo);
            if (to != null) {
                ScriptType.STARTUP.console.info("Remapping " + mapping.key + " to " + idTo + " (" + to.getClass() + ")");
                mapping.remap((IForgeRegistryEntry)UtilsJS.cast(to));
            }
        });
    }

    public void ignore(@ID String key) {
        this.findMapping(key, RegistryEvent.MissingMappings.Mapping::ignore);
    }

    public void warn(@ID String key) {
        this.findMapping(key, RegistryEvent.MissingMappings.Mapping::warn);
    }

    public void fail(@ID String key) {
        this.findMapping(key, RegistryEvent.MissingMappings.Mapping::fail);
    }
}

