/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.client;

import dev.latvian.kubejs.KubeJS;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.loading.FMLPaths;

public class ClientProperties {
    private static ClientProperties instance;
    private final Properties properties;
    private boolean writeProperties;
    private Path icon;
    private boolean tempIconCancel;
    public String title;
    public boolean showTagNames;
    public boolean disableRecipeBook;
    public boolean exportAtlases;
    public int backgroundColor;
    public float[] backgroundColor3f;
    public int barColor;
    public int barBackgroundColor;
    public int barBorderColor;
    public float[] fmlMemoryColor;
    public float[] fmlLogColor;

    public static ClientProperties get() {
        if (instance == null) {
            instance = new ClientProperties();
        }
        return instance;
    }

    private ClientProperties() {
        block33: {
            this.tempIconCancel = true;
            this.properties = new Properties();
            try {
                Path titleFile;
                Path folder = FMLPaths.GAMEDIR.get().resolve("kubejs");
                if (Files.notExists(folder, new LinkOption[0])) {
                    Files.createDirectories(folder, new FileAttribute[0]);
                }
                Path p = folder.resolve("client.properties");
                this.writeProperties = false;
                if (Files.exists(p, new LinkOption[0])) {
                    try (BufferedReader reader = Files.newBufferedReader(p);){
                        this.properties.load(reader);
                    }
                } else {
                    this.writeProperties = true;
                }
                if (Files.exists(titleFile = folder.resolve("packtitle.txt"), new LinkOption[0])) {
                    try {
                        Files.lines(titleFile).findFirst().ifPresent(s -> this.properties.setProperty("title", s.trim()));
                        Files.delete(titleFile);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                this.title = this.get("title", "");
                this.showTagNames = this.get("showTagNames", true);
                this.disableRecipeBook = this.get("disableRecipeBook", false);
                this.exportAtlases = this.get("exportAtlases", false);
                this.backgroundColor = this.getColor("backgroundColor", 0xFFFFFF);
                this.backgroundColor3f = this.getFloatColor(this.backgroundColor);
                this.barColor = this.getColor("barColor", 14821431);
                this.barBackgroundColor = this.getColor("barBackgroundColor", 0xFFFFFF);
                this.barBorderColor = this.getColor("barBorderColor", 0);
                this.fmlMemoryColor = this.getFloatColor("fmlMemoryColor");
                this.fmlLogColor = this.getFloatColor("fmlLogColor");
                Path iconFile = folder.resolve("packicon.png");
                if (Files.exists(iconFile, new LinkOption[0])) {
                    this.icon = iconFile;
                }
                if (!this.writeProperties) break block33;
                try (BufferedWriter writer = Files.newBufferedWriter(p, new OpenOption[0]);){
                    this.properties.store(writer, "KubeJS Client Properties");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        KubeJS.LOGGER.info("Loaded kubejs/client.properties");
    }

    private String get(String key, String def) {
        String s = this.properties.getProperty(key);
        if (s == null) {
            this.properties.setProperty(key, def);
            this.writeProperties = true;
            return def;
        }
        return s;
    }

    private boolean get(String key, boolean def) {
        return this.get(key, def ? "true" : "false").equals("true");
    }

    private int getColor(String key, int def) {
        String s = this.get(key, String.format("#%06X", def & 0xFFFFFF));
        if (s.isEmpty() || s.equals("default")) {
            return def;
        }
        try {
            return 0xFFFFFF & Integer.decode(s.startsWith("#") ? s : "#" + s);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return def;
        }
    }

    private float[] getFloatColor(int color) {
        float[] c = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color >> 0 & 0xFF) / 255.0f};
        return c;
    }

    @Nullable
    private float[] getFloatColor(String key) {
        String s = this.get(key, "default");
        if (s.isEmpty() || s.equals("default")) {
            return null;
        }
        try {
            return this.getFloatColor(Integer.decode(s));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public boolean cancelIconUpdate() {
        if (this.tempIconCancel) {
            if (this.icon != null) {
                try (InputStream stream16 = Files.newInputStream(this.icon, new OpenOption[0]);
                     InputStream stream32 = Files.newInputStream(this.icon, new OpenOption[0]);){
                    this.tempIconCancel = false;
                    Minecraft.func_71410_x().func_228018_at_().func_216529_a(stream16, stream32);
                    this.tempIconCancel = true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

