/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.client;

import dev.latvian.kubejs.KubeJSCommon;
import dev.latvian.kubejs.client.ClientWrapper;
import dev.latvian.kubejs.client.KubeJSClientEventHandler;
import dev.latvian.kubejs.client.KubeJSResourcePackFinder;
import dev.latvian.kubejs.event.EventJS;
import dev.latvian.kubejs.net.NetworkEventJS;
import dev.latvian.kubejs.script.BindingsEvent;
import dev.latvian.kubejs.script.ScriptType;
import dev.latvian.kubejs.util.MapJS;
import dev.latvian.kubejs.util.Overlay;
import dev.latvian.kubejs.world.ClientWorldJS;
import dev.latvian.kubejs.world.WorldJS;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.resources.IPackFinder;
import net.minecraft.resources.ResourcePackList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class KubeJSClient
extends KubeJSCommon {
    public static final Map<String, Overlay> activeOverlays = new LinkedHashMap<String, Overlay>();

    @Override
    public void init(File folder) {
        new KubeJSClientEventHandler().init();
        ResourcePackList list = Minecraft.func_71410_x().func_195548_H();
        list.func_198982_a((IPackFinder)new KubeJSResourcePackFinder(folder));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
    }

    @Override
    public void clientBindings(BindingsEvent event) {
        event.add("client", new ClientWrapper());
    }

    private void setup(FMLClientSetupEvent event) {
        new EventJS().post(ScriptType.STARTUP, "client.init");
    }

    @Override
    public void handleDataToClientPacket(String channel, @Nullable CompoundNBT data) {
        new NetworkEventJS((PlayerEntity)Minecraft.func_71410_x().field_71439_g, channel, MapJS.of(data)).post("player.data_from_server", channel);
    }

    @Override
    @Nullable
    public PlayerEntity getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public void openOverlay(Overlay o) {
        activeOverlays.put(o.id, o);
    }

    @Override
    public void closeOverlay(String id) {
        activeOverlays.remove(id);
    }

    @Override
    public WorldJS getClientWorld() {
        return ClientWorldJS.instance;
    }
}

