/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.client;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.latvian.kubejs.KubeJSObjects;
import dev.latvian.kubejs.block.BlockBuilder;
import dev.latvian.kubejs.client.ClientItemTooltipEventJS;
import dev.latvian.kubejs.client.ClientLoggedInEventJS;
import dev.latvian.kubejs.client.ClientProperties;
import dev.latvian.kubejs.client.ClientTickEventJS;
import dev.latvian.kubejs.client.DebugInfoEventJS;
import dev.latvian.kubejs.client.KubeJSClient;
import dev.latvian.kubejs.core.ImageButtonKJS;
import dev.latvian.kubejs.fluid.FluidBuilder;
import dev.latvian.kubejs.item.ItemBuilder;
import dev.latvian.kubejs.player.AttachPlayerDataEvent;
import dev.latvian.kubejs.script.ScriptType;
import dev.latvian.kubejs.text.Text;
import dev.latvian.kubejs.util.FieldJS;
import dev.latvian.kubejs.util.Overlay;
import dev.latvian.kubejs.util.UtilsJS;
import dev.latvian.kubejs.world.AttachWorldDataEvent;
import dev.latvian.kubejs.world.ClientWorldJS;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import java.nio.IntBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.recipebook.IRecipeShownListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class KubeJSClientEventHandler {
    private static FieldJS<List<Widget>> buttons;
    private static final ResourceLocation RECIPE_BUTTON_TEXTURE;

    public void init() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.addListener(this::debugInfo);
        MinecraftForge.EVENT_BUS.addListener(this::itemTooltip);
        MinecraftForge.EVENT_BUS.addListener(this::clientTick);
        MinecraftForge.EVENT_BUS.addListener(this::loggedIn);
        MinecraftForge.EVENT_BUS.addListener(this::loggedOut);
        MinecraftForge.EVENT_BUS.addListener(this::respawn);
        MinecraftForge.EVENT_BUS.addListener(this::inGameScreenDraw);
        MinecraftForge.EVENT_BUS.addListener(this::guiScreenDraw);
        MinecraftForge.EVENT_BUS.addListener(this::guiPostInit);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::itemColors);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::blockColors);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::postAtlasStitch);
    }

    private void setup(FMLClientSetupEvent event) {
        for (BlockBuilder builder : KubeJSObjects.BLOCKS.values()) {
            switch (builder.renderType) {
                case "cutout": {
                    RenderTypeLookup.setRenderLayer((Block)builder.block, (RenderType)RenderType.func_228643_e_());
                    break;
                }
                case "cutout_mipped": {
                    RenderTypeLookup.setRenderLayer((Block)builder.block, (RenderType)RenderType.func_228641_d_());
                    break;
                }
                case "translucent": {
                    RenderTypeLookup.setRenderLayer((Block)builder.block, (RenderType)RenderType.func_228645_f_());
                }
            }
        }
    }

    private void debugInfo(RenderGameOverlayEvent.Text event) {
        if (Minecraft.func_71410_x().field_71439_g != null) {
            new DebugInfoEventJS(event).post(ScriptType.CLIENT, "client.debug_info");
        }
    }

    private void itemTooltip(ItemTooltipEvent event) {
        if (ClientProperties.get().showTagNames && Minecraft.func_71410_x().field_71474_y.field_82882_x && Screen.hasShiftDown()) {
            for (ResourceLocation tag : event.getItemStack().func_77973_b().getTags()) {
                event.getToolTip().add(new StringTextComponent(" #" + tag).func_211708_a(TextFormatting.DARK_GRAY));
            }
        }
        new ClientItemTooltipEventJS(event).post(ScriptType.CLIENT, "client.item_tooltip");
    }

    private void clientTick(TickEvent.ClientTickEvent event) {
        if (Minecraft.func_71410_x().field_71439_g != null) {
            new ClientTickEventJS(ClientWorldJS.instance.clientPlayerData.getPlayer()).post("client.tick");
        }
    }

    private void loggedIn(ClientPlayerNetworkEvent.LoggedInEvent event) {
        ClientWorldJS.instance = new ClientWorldJS(Minecraft.func_71410_x(), event.getPlayer());
        MinecraftForge.EVENT_BUS.post((Event)new AttachWorldDataEvent(ClientWorldJS.instance));
        MinecraftForge.EVENT_BUS.post((Event)new AttachPlayerDataEvent(ClientWorldJS.instance.clientPlayerData));
        new ClientLoggedInEventJS(ClientWorldJS.instance.clientPlayerData.getPlayer()).post("client.logged_in");
    }

    private void loggedOut(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        if (ClientWorldJS.instance != null) {
            new ClientLoggedInEventJS(ClientWorldJS.instance.clientPlayerData.getPlayer()).post("client.logged_out");
        }
        ClientWorldJS.instance = null;
        KubeJSClient.activeOverlays.clear();
    }

    private void respawn(ClientPlayerNetworkEvent.RespawnEvent event) {
        ClientWorldJS.instance = new ClientWorldJS(Minecraft.func_71410_x(), event.getNewPlayer());
        MinecraftForge.EVENT_BUS.post((Event)new AttachWorldDataEvent(ClientWorldJS.instance));
        MinecraftForge.EVENT_BUS.post((Event)new AttachPlayerDataEvent(ClientWorldJS.instance.clientPlayerData));
    }

    private int drawOverlay(Minecraft mc, int maxWidth, int x, int y, int p, Overlay o, boolean inv) {
        ArrayList list = new ArrayList();
        int l = 10;
        for (Text text : o.text) {
            list.addAll(mc.field_71466_p.func_78271_c(text.getFormattedString(), maxWidth));
        }
        int mw = 0;
        for (String s : list) {
            mw = Math.max(mw, mc.field_71466_p.func_78256_a(s));
        }
        if (mw == 0) {
            return 0;
        }
        int n = mw + p * 2;
        int h = list.size() * l + p * 2 - 2;
        int col = 0xFF000000 | o.color;
        int r = col >> 16 & 0xFF;
        int g = col >> 8 & 0xFF;
        int b = col & 0xFF;
        RenderSystem.disableTexture();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        if (inv) {
            this.addRectToBuffer(buffer, x, y, n, h, r, g, b, 255);
            this.addRectToBuffer(buffer, x, y + 1, 1, h - 2, 0, 0, 0, 80);
            this.addRectToBuffer(buffer, x + n - 1, y + 1, 1, h - 2, 0, 0, 0, 80);
            this.addRectToBuffer(buffer, x, y, n, 1, 0, 0, 0, 80);
            this.addRectToBuffer(buffer, x, y + h - 1, n, 1, 0, 0, 0, 80);
        } else {
            this.addRectToBuffer(buffer, x, y, n, h, r, g, b, 200);
            this.addRectToBuffer(buffer, x, y + 1, 1, h - 2, r, g, b, 255);
            this.addRectToBuffer(buffer, x + n - 1, y + 1, 1, h - 2, r, g, b, 255);
            this.addRectToBuffer(buffer, x, y, n, 1, r, g, b, 255);
            this.addRectToBuffer(buffer, x, y + h - 1, n, 1, r, g, b, 255);
        }
        tessellator.func_78381_a();
        RenderSystem.enableTexture();
        for (int i = 0; i < list.size(); ++i) {
            mc.field_71466_p.func_175063_a((String)list.get(i), (float)(x + p), (float)(y + i * l + p), -1);
        }
        return list.size() * l + p * 2 + (p - 2);
    }

    private void addRectToBuffer(BufferBuilder buffer, int x, int y, int w, int h, int r, int g, int b, int a) {
        buffer.func_225582_a_((double)x, (double)(y + h), 0.0).func_225586_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_((double)(x + w), (double)(y + h), 0.0).func_225586_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_((double)(x + w), (double)y, 0.0).func_225586_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_((double)x, (double)y, 0.0).func_225586_a_(r, g, b, a).func_181675_d();
    }

    private void inGameScreenDraw(RenderGameOverlayEvent.Post event) {
        int p;
        if (KubeJSClient.activeOverlays.isEmpty() || event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71474_y.field_74330_P || mc.field_71462_r != null) {
            return;
        }
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)800.0f);
        RenderSystem.enableBlend();
        RenderSystem.disableLighting();
        int maxWidth = mc.func_228018_at_().func_198107_o() / 4;
        int spx = p = 4;
        int spy = p;
        for (Overlay o : KubeJSClient.activeOverlays.values()) {
            spy += this.drawOverlay(mc, maxWidth, spx, spy, p, o, false);
        }
        RenderSystem.popMatrix();
    }

    private void guiScreenDraw(GuiScreenEvent.DrawScreenEvent.Post event) {
        int p;
        if (KubeJSClient.activeOverlays.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)800.0f);
        RenderSystem.enableBlend();
        RenderSystem.disableLighting();
        int maxWidth = mc.func_228018_at_().func_198107_o() / 4;
        int spx = p = 4;
        int spy = p;
        if (buttons == null) {
            buttons = UtilsJS.getField(Screen.class, "buttons");
        }
        while (this.isOver(buttons.get(event.getGui()).orElse(Collections.emptyList()), spx, spy)) {
            spy += 16;
        }
        for (Overlay o : KubeJSClient.activeOverlays.values()) {
            if (!o.alwaysOnTop) continue;
            spy += this.drawOverlay(mc, maxWidth, spx, spy, p, o, true);
        }
        RenderSystem.popMatrix();
    }

    private boolean isOver(List<Widget> list, int x, int y) {
        for (Widget w : list) {
            if (!w.visible || x < w.x || y < w.y || x >= w.x + w.getWidth() || y >= w.y + w.getHeight()) continue;
            return true;
        }
        return false;
    }

    private void guiPostInit(GuiScreenEvent.InitGuiEvent.Post event) {
        if (ClientProperties.get().disableRecipeBook && event.getGui() instanceof IRecipeShownListener) {
            for (Widget widget : event.getWidgetList()) {
                if (!(widget instanceof ImageButtonKJS) || !RECIPE_BUTTON_TEXTURE.equals((Object)((ImageButtonKJS)widget).getButtonTextureKJS())) continue;
                event.removeWidget(widget);
                return;
            }
        }
    }

    private void itemColors(ColorHandlerEvent.Item event) {
        for (ItemBuilder itemBuilder : KubeJSObjects.ITEMS.values()) {
            if (itemBuilder.color.isEmpty()) continue;
            event.getItemColors().func_199877_a((stack, index) -> builder.color.get(index), new IItemProvider[]{itemBuilder.item});
        }
        for (BlockBuilder blockBuilder : KubeJSObjects.BLOCKS.values()) {
            if (blockBuilder.itemBuilder == null || blockBuilder.color.isEmpty()) continue;
            event.getItemColors().func_199877_a((stack, index) -> builder.color.get(index), new IItemProvider[]{blockBuilder.itemBuilder.blockItem});
        }
        for (FluidBuilder fluidBuilder : KubeJSObjects.FLUIDS.values()) {
            if (fluidBuilder.stillFluid.getAttributes().getColor() == -1) continue;
            event.getItemColors().func_199877_a((stack, index) -> index == 1 ? builder.stillFluid.getAttributes().getColor() : -1, new IItemProvider[]{fluidBuilder.bucketItem});
        }
    }

    private void blockColors(ColorHandlerEvent.Block event) {
        for (BlockBuilder builder : KubeJSObjects.BLOCKS.values()) {
            if (builder.color.isEmpty()) continue;
            event.getBlockColors().func_186722_a((state, world, pos, index) -> builder.color.get(index), new Block[]{builder.block});
        }
    }

    private void postAtlasStitch(TextureStitchEvent.Post event) {
        if (!ClientProperties.get().exportAtlases) {
            return;
        }
        GL11.glBindTexture((int)3553, (int)event.getMap().func_110552_b());
        int w = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
        int h = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
        if (w <= 0 || h <= 0) {
            return;
        }
        BufferedImage image = new BufferedImage(w, h, 2);
        int[] pixels = new int[w * h];
        IntBuffer result = BufferUtils.createIntBuffer((int)(w * h));
        GL11.glGetTexImage((int)3553, (int)0, (int)32993, (int)33639, (IntBuffer)result);
        result.get(pixels);
        image.setRGB(0, 0, w, h, pixels, 0, w);
        Path path = FMLPaths.GAMEDIR.get().resolve("kubejs/exported/" + event.getMap().func_229223_g_().func_110624_b() + "/" + event.getMap().func_229223_g_().func_110623_a());
        if (!Files.exists(path.getParent(), new LinkOption[0])) {
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
        }
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createFile(path, new FileAttribute[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
        }
        try (OutputStream stream = Files.newOutputStream(path, new OpenOption[0]);){
            ImageIO.write((RenderedImage)image, "PNG", stream);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        RECIPE_BUTTON_TEXTURE = new ResourceLocation("textures/gui/recipe_button.png");
    }
}

