/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.entity;

import dev.latvian.kubejs.entity.CheckLivingEntitySpawnEventJS;
import dev.latvian.kubejs.entity.EntitySpawnedEventJS;
import dev.latvian.kubejs.entity.ItemEntityJS;
import dev.latvian.kubejs.entity.LivingEntityAttackEventJS;
import dev.latvian.kubejs.entity.LivingEntityDeathEventJS;
import dev.latvian.kubejs.entity.LivingEntityDropsEventJS;
import dev.latvian.kubejs.script.ScriptType;
import dev.latvian.kubejs.server.ServerJS;
import net.minecraft.entity.item.ItemEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.Event;

public class KubeJSEntityEventHandler {
    public void init() {
        MinecraftForge.EVENT_BUS.addListener(this::livingDeath);
        MinecraftForge.EVENT_BUS.addListener(this::livingAttack);
        MinecraftForge.EVENT_BUS.addListener(this::livingDrops);
        MinecraftForge.EVENT_BUS.addListener(this::checkLivingSpawn);
        MinecraftForge.EVENT_BUS.addListener(this::entitySpawned);
    }

    private void livingDeath(LivingDeathEvent event) {
        if (new LivingEntityDeathEventJS(event).post("entity.death")) {
            event.setCanceled(true);
        }
    }

    private void livingAttack(LivingAttackEvent event) {
        if (event.getAmount() > 0.0f && new LivingEntityAttackEventJS(event).post("entity.attack")) {
            event.setCanceled(true);
        }
    }

    private void livingDrops(LivingDropsEvent event) {
        if (event.getEntity().field_70170_p.func_201670_d()) {
            return;
        }
        LivingEntityDropsEventJS e = new LivingEntityDropsEventJS(event);
        if (e.post("entity.drops")) {
            event.setCanceled(true);
        } else if (e.drops != null) {
            event.getDrops().clear();
            for (ItemEntityJS ie : e.drops) {
                event.getDrops().add((ItemEntity)ie.minecraftEntity);
            }
        }
    }

    private void checkLivingSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (ServerJS.instance != null && ServerJS.instance.overworld != null && !event.getWorld().func_201670_d() && new CheckLivingEntitySpawnEventJS(event).post(ScriptType.SERVER, "entity.check_spawn")) {
            event.setResult(Event.Result.DENY);
        }
    }

    private void entitySpawned(EntityJoinWorldEvent event) {
        if (ServerJS.instance != null && ServerJS.instance.overworld != null && !event.getWorld().func_201670_d() && new EntitySpawnedEventJS(event).post(ScriptType.SERVER, "entity.spawned")) {
            event.setCanceled(true);
        }
    }
}

