/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.event;

import dev.latvian.kubejs.event.EventJS;
import dev.latvian.kubejs.event.IEventHandler;
import dev.latvian.kubejs.script.ScriptFile;
import dev.latvian.kubejs.script.ScriptManager;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class EventsJS {
    public final ScriptManager scriptManager;
    private final Map<String, List<ScriptEventHandler>> map;

    public EventsJS(ScriptManager t) {
        this.scriptManager = t;
        this.map = new Object2ObjectOpenHashMap();
    }

    public void listen(String id, IEventHandler handler) {
        ObjectArrayList list = this.map.get(id);
        if (list == null) {
            list = new ObjectArrayList();
            this.map.put(id, (List<ScriptEventHandler>)list);
        }
        list.add(new ScriptEventHandler(this.scriptManager.currentFile, handler));
    }

    public List<ScriptEventHandler> handlers(String id) {
        List<ScriptEventHandler> list = this.map.get(id);
        return list == null ? Collections.emptyList() : list;
    }

    public boolean postToHandlers(String id, List<ScriptEventHandler> list, EventJS event) {
        if (list.isEmpty()) {
            return false;
        }
        boolean c = event.canCancel();
        for (ScriptEventHandler handler : list) {
            this.scriptManager.currentFile = handler.file;
            try {
                handler.handler.onEvent(event);
                if (!c || !event.isCancelled()) continue;
                return true;
            }
            catch (Throwable ex) {
                if (ex.getClass().getName().equals("jdk.nashorn.api.scripting.NashornException")) {
                    ((ScriptEventHandler)handler).file.pack.manager.type.console.error("Error occurred while firing '" + id + "' event in " + ((ScriptEventHandler)handler).file.info.location + ": " + ex);
                    continue;
                }
                ex.printStackTrace();
            }
        }
        return false;
    }

    public void clear() {
        this.map.clear();
    }

    private static class ScriptEventHandler {
        private final ScriptFile file;
        private final IEventHandler handler;

        private ScriptEventHandler(ScriptFile f, IEventHandler h) {
            this.file = f;
            this.handler = h;
        }
    }
}

