/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.fluid;

import dev.latvian.kubejs.docs.ID;
import dev.latvian.kubejs.fluid.BucketItemJS;
import dev.latvian.kubejs.util.BuilderBase;
import dev.latvian.kubejs.util.UtilsJS;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.item.Rarity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public class FluidBuilder
extends BuilderBase {
    public String stillTexture;
    public String flowingTexture;
    private int color = -1;
    private int luminosity = 0;
    private int density = 1000;
    private int temperature = 300;
    private int viscosity = 1000;
    private boolean isGaseous;
    private Rarity rarity = Rarity.COMMON;
    public ForgeFlowingFluid.Source stillFluid;
    public ForgeFlowingFluid.Flowing flowingFluid;
    public BucketItemJS bucketItem;
    public FlowingFluidBlock block;

    public FluidBuilder(String i) {
        super(i);
        this.textureThin(0xFF0000);
    }

    @Override
    public String getType() {
        return "fluid";
    }

    public FluidBuilder color(int c) {
        this.color = c;
        if ((this.color & 0xFFFFFF) == this.color) {
            this.color |= 0xFF000000;
        }
        return this;
    }

    public FluidBuilder textureStill(@ID String id) {
        this.stillTexture = UtilsJS.getID(id);
        return this;
    }

    public FluidBuilder textureFlowing(@ID String id) {
        this.flowingTexture = UtilsJS.getID(id);
        return this;
    }

    public FluidBuilder textureThick(int color) {
        return this.textureStill("kubejs:fluid/fluid_thick").textureFlowing("kubejs:fluid/fluid_thick_flow").color(color);
    }

    public FluidBuilder textureThin(int color) {
        return this.textureStill("kubejs:fluid/fluid_thin").textureFlowing("kubejs:fluid/fluid_thin_flow").color(color);
    }

    public FluidBuilder luminosity(int luminosity) {
        this.luminosity = luminosity;
        return this;
    }

    public FluidBuilder density(int density) {
        this.density = density;
        return this;
    }

    public FluidBuilder temperature(int temperature) {
        this.temperature = temperature;
        return this;
    }

    public FluidBuilder viscosity(int viscosity) {
        this.viscosity = viscosity;
        return this;
    }

    public FluidBuilder gaseous() {
        this.isGaseous = true;
        return this;
    }

    public FluidBuilder rarity(Rarity rarity) {
        this.rarity = rarity;
        return this;
    }

    public ForgeFlowingFluid.Properties createProperties() {
        FluidAttributes.Builder builder = FluidAttributes.builder((ResourceLocation)new ResourceLocation(this.stillTexture), (ResourceLocation)new ResourceLocation(this.flowingTexture)).translationKey("fluid." + this.id.func_110624_b() + "." + this.id.func_110623_a()).color(this.color).rarity(this.rarity).density(this.density).viscosity(this.viscosity).luminosity(this.luminosity).temperature(this.temperature).rarity(this.rarity);
        if (this.isGaseous) {
            builder.gaseous();
        }
        return new ForgeFlowingFluid.Properties(() -> this.stillFluid, () -> this.flowingFluid, builder).bucket(() -> this.bucketItem).block(() -> this.block);
    }
}

