/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.fluid;

import dev.latvian.kubejs.fluid.BoundFluidStackJS;
import dev.latvian.kubejs.fluid.EmptyFluidStackJS;
import dev.latvian.kubejs.fluid.UnboundFluidStackJS;
import dev.latvian.kubejs.util.JSObjectType;
import dev.latvian.kubejs.util.MapJS;
import dev.latvian.kubejs.util.UtilsJS;
import dev.latvian.kubejs.util.WrappedJSObjectChangeListener;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class FluidStackJS
implements WrappedJSObjectChangeListener<MapJS> {
    public static FluidStackJS of(@Nullable Object o) {
        if (o == null) {
            return EmptyFluidStackJS.INSTANCE;
        }
        if (o instanceof FluidStackJS) {
            return (FluidStackJS)o;
        }
        if (o instanceof FluidStack) {
            return new BoundFluidStackJS((FluidStack)o);
        }
        if (o instanceof Fluid) {
            return new UnboundFluidStackJS(((Fluid)o).getRegistryName());
        }
        MapJS map = MapJS.of(o);
        if (map != null && map.containsKey("fluid")) {
            UnboundFluidStackJS stack = new UnboundFluidStackJS(new ResourceLocation(map.get("fluid").toString()));
            if (map.get("amount") instanceof Number) {
                ((FluidStackJS)stack).setAmount(((Number)map.get("amount")).intValue());
            }
            if (map.containsKey("nbt")) {
                ((FluidStackJS)stack).setNbt(map.get("nbt"));
            }
            return stack;
        }
        String[] s = o.toString().split(" ", 2);
        return new UnboundFluidStackJS(new ResourceLocation(s[0])).amount(UtilsJS.parseInt(s.length == 2 ? s[1] : "", 1000));
    }

    public static FluidStackJS of(@Nullable Object o, @Nullable Object amountOrNBT) {
        FluidStackJS stack = FluidStackJS.of(o);
        Object n = UtilsJS.wrap(amountOrNBT, JSObjectType.ANY);
        if (n instanceof Number) {
            stack.setAmount(((Number)n).intValue());
        } else if (n instanceof MapJS) {
            stack.setNbt(n);
        }
        return stack;
    }

    public static FluidStackJS of(@Nullable Object o, int amount, @Nullable Object nbt) {
        FluidStackJS stack = FluidStackJS.of(o);
        stack.setAmount(amount);
        stack.setNbt(nbt);
        return stack;
    }

    public abstract String getId();

    public Fluid getFluid() {
        Fluid f = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(this.getId()));
        return f == null ? Fluids.field_204541_a : f;
    }

    public abstract FluidStack getFluidStack();

    public boolean isEmpty() {
        return this.getAmount() <= 0;
    }

    public abstract int getAmount();

    public abstract void setAmount(int var1);

    public final FluidStackJS amount(int amount) {
        this.setAmount(amount);
        return this;
    }

    @Nullable
    public abstract MapJS getNbt();

    public abstract void setNbt(@Nullable Object var1);

    public final FluidStackJS nbt(@Nullable Object nbt) {
        this.setNbt(nbt);
        return this;
    }

    public abstract FluidStackJS copy();

    public int hashCode() {
        return Objects.hash(this.getFluid(), this.getNbt());
    }

    public boolean equals(Object o) {
        FluidStackJS f = FluidStackJS.of(o);
        if (f.isEmpty()) {
            return false;
        }
        return this.getFluid() == f.getFluid() && Objects.equals(this.getNbt(), f.getNbt());
    }

    public boolean strongEquals(Object o) {
        FluidStackJS f = FluidStackJS.of(o);
        if (f.isEmpty()) {
            return false;
        }
        return this.getAmount() == f.getAmount() && this.getFluid() == f.getFluid() && Objects.equals(this.getNbt(), f.getNbt());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int amount = this.getAmount();
        MapJS nbt = this.getNbt();
        if (amount != 1000 || nbt != null) {
            builder.append("fluid.of('");
            builder.append(this.getId());
            builder.append("')");
            if (amount != 1000) {
                builder.append(".amount(");
                builder.append(amount);
                builder.append(')');
            }
            if (nbt != null) {
                builder.append(".nbt(");
                nbt.toString(builder);
                builder.append(')');
            }
        } else {
            builder.append('\'');
            builder.append(this.getId());
            builder.append('\'');
        }
        return builder.toString();
    }

    @Override
    public void onChanged(MapJS o) {
    }
}

