/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.fluid;

import dev.latvian.kubejs.fluid.FluidStackJS;
import dev.latvian.kubejs.util.MapJS;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class UnboundFluidStackJS
extends FluidStackJS {
    private final ResourceLocation fluidRL;
    private final String fluid;
    private int amount;
    private MapJS nbt;
    private FluidStack cached;

    public UnboundFluidStackJS(ResourceLocation f) {
        this.fluidRL = f;
        this.fluid = this.fluidRL.toString();
        this.amount = 1000;
        this.nbt = null;
        this.cached = null;
    }

    @Override
    public String getId() {
        return this.fluid;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() || this.getFluid() == Fluids.field_204541_a;
    }

    @Override
    public FluidStack getFluidStack() {
        if (this.cached == null) {
            this.cached = new FluidStack(this.getFluid(), this.amount, MapJS.nbt(this.nbt));
        }
        return this.cached;
    }

    @Override
    public int getAmount() {
        return this.amount;
    }

    @Override
    public void setAmount(int a) {
        this.amount = a;
        this.cached = null;
    }

    @Override
    @Nullable
    public MapJS getNbt() {
        return this.nbt;
    }

    @Override
    public void setNbt(@Nullable Object n) {
        this.nbt = MapJS.of(n);
        if (this.nbt != null) {
            this.nbt.changeListener = this;
        }
        this.cached = null;
    }

    @Override
    public FluidStackJS copy() {
        return new UnboundFluidStackJS(this.fluidRL).amount(this.amount).nbt(this.nbt);
    }

    @Override
    public void onChanged(@Nullable MapJS o) {
        this.cached = null;
    }
}

