/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.integration.gamestages;

import dev.latvian.kubejs.integration.gamestages.GameStageKJSHelper;
import dev.latvian.kubejs.player.PlayerDataJS;
import java.util.ArrayList;
import java.util.Collection;
import net.darkhax.gamestages.GameStageHelper;
import net.minecraft.entity.player.ServerPlayerEntity;

public class GameStagesPlayerData {
    private final PlayerDataJS playerData;

    public GameStagesPlayerData(PlayerDataJS d) {
        this.playerData = d;
    }

    public boolean has(String stage) {
        return GameStageKJSHelper.hasStage(this.playerData.getMinecraftPlayer(), stage);
    }

    public void add(String stage) {
        if (this.playerData.getMinecraftPlayer() instanceof ServerPlayerEntity) {
            GameStageHelper.addStage((ServerPlayerEntity)((ServerPlayerEntity)this.playerData.getMinecraftPlayer()), (String)stage);
        }
    }

    public void remove(String stage) {
        if (this.playerData.getMinecraftPlayer() instanceof ServerPlayerEntity) {
            GameStageHelper.removeStage((ServerPlayerEntity)((ServerPlayerEntity)this.playerData.getMinecraftPlayer()), (String)stage);
        }
    }

    public boolean set(String stage, boolean value) {
        if (value) {
            this.add(stage);
            return true;
        }
        this.remove(stage);
        return false;
    }

    public boolean toggle(String stage) {
        return this.set(stage, !this.has(stage));
    }

    public Collection<String> getList() {
        return GameStageHelper.getPlayerData(this.playerData.getMinecraftPlayer()).getStages();
    }

    public void clear() {
        for (String s : new ArrayList<String>(this.getList())) {
            this.remove(s);
        }
    }

    public void sync() {
        if (this.playerData.getMinecraftPlayer() instanceof ServerPlayerEntity) {
            GameStageHelper.syncPlayer((ServerPlayerEntity)((ServerPlayerEntity)this.playerData.getMinecraftPlayer()));
        }
    }
}

