/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.integration.jei;

import dev.latvian.kubejs.bindings.DefaultBindings;
import dev.latvian.kubejs.fluid.FluidStackJS;
import dev.latvian.kubejs.integration.jei.AddJEIEventJS;
import dev.latvian.kubejs.integration.jei.AddJEISubtypesEventJS;
import dev.latvian.kubejs.integration.jei.HideJEIEventJS;
import dev.latvian.kubejs.integration.jei.InformationJEIEventJS;
import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.item.ingredient.IngredientJS;
import dev.latvian.kubejs.script.ScriptType;
import java.util.ArrayList;
import java.util.Collections;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public IJeiRuntime runtime;

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("kubejs", "jei");
    }

    public void onRuntimeAvailable(IJeiRuntime r) {
        this.runtime = r;
        DefaultBindings.GLOBAL.put("jeiRuntime", (Object)this.runtime);
        new HideJEIEventJS(this.runtime, VanillaTypes.ITEM, object -> {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (ItemStackJS stack : IngredientJS.of(object).getStacks()) {
                list.add(stack.getItemStack());
            }
            return list;
        }).post(ScriptType.CLIENT, "jei.hide.items");
        new HideJEIEventJS(this.runtime, VanillaTypes.FLUID, object -> {
            FluidStackJS fs = FluidStackJS.of(object);
            return fs.isEmpty() ? Collections.emptyList() : Collections.singletonList(fs.getFluidStack());
        }).post(ScriptType.CLIENT, "jei.hide.fluids");
        new AddJEIEventJS<ItemStack>(this.runtime, VanillaTypes.ITEM, object -> ItemStackJS.of(object).getItemStack()).post(ScriptType.CLIENT, "jei.add.items");
        new AddJEIEventJS<FluidStack>(this.runtime, VanillaTypes.FLUID, object -> FluidStackJS.of(object).getFluidStack()).post(ScriptType.CLIENT, "jei.add.fluids");
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        new AddJEISubtypesEventJS(registration).post(ScriptType.CLIENT, "jei.subtypes");
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ArrayList list = new ArrayList();
        new InformationJEIEventJS(list).post(ScriptType.CLIENT, "jei.information");
        registration.addRecipes(list, VanillaRecipeCategoryUid.INFORMATION);
    }
}

