/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.item;

import com.google.common.collect.Lists;
import dev.latvian.kubejs.docs.ID;
import dev.latvian.kubejs.item.ItemFoodEatenEventJS;
import dev.latvian.kubejs.util.UtilsJS;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.item.Food;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class FoodBuilder {
    private int hunger;
    private float saturation;
    private boolean meat;
    private boolean alwaysEdible;
    private boolean fastToEat;
    private final List<Pair<Supplier<EffectInstance>, Float>> effects = Lists.newArrayList();
    public Consumer<ItemFoodEatenEventJS> eaten;

    public FoodBuilder hunger(int h) {
        this.hunger = h;
        return this;
    }

    public FoodBuilder saturation(float s) {
        this.saturation = s;
        return this;
    }

    public FoodBuilder meat() {
        this.meat = true;
        return this;
    }

    public FoodBuilder alwaysEdible() {
        this.alwaysEdible = true;
        return this;
    }

    public FoodBuilder fastToEat() {
        this.fastToEat = true;
        return this;
    }

    public FoodBuilder effect(@ID String potion, int duration, int amplifier, float probability) {
        ResourceLocation id = UtilsJS.getMCID(potion);
        this.effects.add((Pair<Supplier<EffectInstance>, Float>)Pair.of(() -> new EffectInstance((Effect)ForgeRegistries.POTIONS.getValue(id), duration, amplifier), (Object)Float.valueOf(probability)));
        return this;
    }

    public FoodBuilder eaten(Consumer<ItemFoodEatenEventJS> e) {
        this.eaten = e;
        return this;
    }

    public Food build() {
        Food.Builder b = new Food.Builder();
        b.func_221456_a(this.hunger);
        b.func_221454_a(this.saturation);
        if (this.meat) {
            b.func_221451_a();
        }
        if (this.alwaysEdible) {
            b.func_221455_b();
        }
        if (this.fastToEat) {
            b.func_221457_c();
        }
        for (Pair<Supplier<EffectInstance>, Float> effect : this.effects) {
            b.effect((Supplier)effect.getKey(), ((Float)effect.getRight()).floatValue());
        }
        return b.func_221453_d();
    }
}

