/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.item;

import dev.latvian.kubejs.docs.MinecraftClass;
import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.item.ingredient.IngredientJS;
import dev.latvian.kubejs.item.ingredient.MatchAllIngredientJS;
import dev.latvian.kubejs.world.BlockContainerJS;
import dev.latvian.kubejs.world.WorldJS;
import java.util.LinkedList;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;

public class InventoryJS {
    @MinecraftClass
    public final IItemHandler minecraftInventory;

    public InventoryJS(IItemHandler h) {
        this.minecraftInventory = h;
    }

    public InventoryJS(IInventory h) {
        this.minecraftInventory = new InvWrapper(h);
    }

    public int getSize() {
        return this.minecraftInventory.getSlots();
    }

    public ItemStackJS get(int slot) {
        return ItemStackJS.of(this.minecraftInventory.getStackInSlot(slot));
    }

    public void set(int slot, Object item) {
        if (!(this.minecraftInventory instanceof IItemHandlerModifiable)) {
            throw new IllegalStateException("This inventory can't be modified directly! Use insert/extract methods!");
        }
        ((IItemHandlerModifiable)this.minecraftInventory).setStackInSlot(slot, ItemStackJS.of(item).getItemStack());
    }

    public ItemStackJS insert(int slot, Object item, boolean simulate) {
        return ItemStackJS.of(this.minecraftInventory.insertItem(slot, ItemStackJS.of(item).getItemStack(), simulate));
    }

    public ItemStackJS extract(int slot, int amount, boolean simulate) {
        return ItemStackJS.of(this.minecraftInventory.extractItem(slot, amount, simulate));
    }

    public int getSlotLimit(int slot) {
        return this.minecraftInventory.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, Object item) {
        return this.minecraftInventory.isItemValid(slot, ItemStackJS.of(item).getItemStack());
    }

    public void clear() {
        IItemHandlerModifiable modInv = this.minecraftInventory instanceof IItemHandlerModifiable ? (IItemHandlerModifiable)this.minecraftInventory : null;
        for (int i = this.minecraftInventory.getSlots(); i >= 0; --i) {
            if (modInv != null) {
                modInv.setStackInSlot(i, ItemStack.field_190927_a);
                continue;
            }
            this.minecraftInventory.extractItem(i, this.minecraftInventory.getStackInSlot(i).func_190916_E(), false);
        }
    }

    public void clear(Object o) {
        IngredientJS ingredient = IngredientJS.of(o);
        if (ingredient == MatchAllIngredientJS.INSTANCE) {
            this.clear();
        }
        IItemHandlerModifiable modInv = this.minecraftInventory instanceof IItemHandlerModifiable ? (IItemHandlerModifiable)this.minecraftInventory : null;
        for (int i = this.minecraftInventory.getSlots(); i >= 0; --i) {
            if (!ingredient.testVanilla(this.minecraftInventory.getStackInSlot(i))) continue;
            if (modInv != null) {
                modInv.setStackInSlot(i, ItemStack.field_190927_a);
                continue;
            }
            this.minecraftInventory.extractItem(i, this.minecraftInventory.getStackInSlot(i).func_190916_E(), false);
        }
    }

    public int find() {
        for (int i = 0; i < this.minecraftInventory.getSlots(); ++i) {
            ItemStack stack1 = this.minecraftInventory.getStackInSlot(i);
            if (stack1.func_190926_b()) continue;
            return i;
        }
        return -1;
    }

    public int find(Object o) {
        IngredientJS ingredient = IngredientJS.of(o);
        if (ingredient == MatchAllIngredientJS.INSTANCE) {
            return this.find();
        }
        for (int i = 0; i < this.minecraftInventory.getSlots(); ++i) {
            ItemStack stack1 = this.minecraftInventory.getStackInSlot(i);
            if (!ingredient.testVanilla(stack1)) continue;
            return i;
        }
        return -1;
    }

    public int count() {
        int count = 0;
        for (int i = 0; i < this.minecraftInventory.getSlots(); ++i) {
            count += this.minecraftInventory.getStackInSlot(i).func_190916_E();
        }
        return count;
    }

    public int count(Object o) {
        IngredientJS ingredient = IngredientJS.of(o);
        if (ingredient == MatchAllIngredientJS.INSTANCE) {
            return this.count();
        }
        int count = 0;
        for (int i = 0; i < this.minecraftInventory.getSlots(); ++i) {
            ItemStack stack1 = this.minecraftInventory.getStackInSlot(i);
            if (!ingredient.testVanilla(stack1)) continue;
            count += stack1.func_190916_E();
        }
        return count;
    }

    public int countNonEmpty() {
        int count = 0;
        for (int i = 0; i < this.minecraftInventory.getSlots(); ++i) {
            if (this.minecraftInventory.getStackInSlot(i).func_190926_b()) continue;
            ++count;
        }
        return count;
    }

    public int countNonEmpty(Object o) {
        IngredientJS ingredient = IngredientJS.of(o);
        if (ingredient == MatchAllIngredientJS.INSTANCE) {
            return this.countNonEmpty();
        }
        int count = 0;
        for (int i = 0; i < this.minecraftInventory.getSlots(); ++i) {
            ItemStack stack1 = this.minecraftInventory.getStackInSlot(i);
            if (!ingredient.testVanilla(stack1)) continue;
            ++count;
        }
        return count;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.minecraftInventory.getSlots(); ++i) {
            if (this.minecraftInventory.getStackInSlot(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        LinkedList<String> list = new LinkedList<String>();
        for (int i = 0; i < this.getSize(); ++i) {
            list.add(this.get(i).toString());
        }
        return list.toString();
    }

    public void markDirty() {
        if (this.minecraftInventory instanceof InvWrapper) {
            ((InvWrapper)this.minecraftInventory).getInv().func_70296_d();
        }
    }

    @Nullable
    public BlockContainerJS getBlock(WorldJS world) {
        IInventory inv;
        if (this.minecraftInventory instanceof InvWrapper && (inv = ((InvWrapper)this.minecraftInventory).getInv()) instanceof TileEntity) {
            return world.getBlock((TileEntity)inv);
        }
        return null;
    }
}

