/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.item;

import dev.latvian.kubejs.docs.ID;
import dev.latvian.kubejs.item.FoodBuilder;
import dev.latvian.kubejs.item.ItemJS;
import dev.latvian.kubejs.text.Text;
import dev.latvian.kubejs.util.BuilderBase;
import dev.latvian.kubejs.util.UtilsJS;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemBuilder
extends BuilderBase {
    public int maxStackSize = 64;
    public int maxDamage = 0;
    public String containerItem = "minecraft:air";
    public Map<ToolType, Integer> tools = new HashMap<ToolType, Integer>();
    public Rarity rarity = Rarity.COMMON;
    public boolean glow = false;
    public final List<Text> tooltip = new ArrayList<Text>();
    public ItemGroup group = ItemGroup.field_78026_f;
    public Int2IntOpenHashMap color = new Int2IntOpenHashMap();
    public String texture;
    public String parentModel;
    public FoodBuilder foodBuilder;
    public ItemJS item;

    public ItemBuilder(String i) {
        super(i);
        this.color.defaultReturnValue(-1);
        this.texture = this.id.func_110624_b() + ":item/" + this.id.func_110623_a();
        this.parentModel = "item/generated";
        this.foodBuilder = null;
        this.displayName = "";
    }

    @Override
    public String getType() {
        return "item";
    }

    public ItemBuilder maxStackSize(int v) {
        this.maxStackSize = v;
        return this;
    }

    public ItemBuilder unstackable() {
        return this.maxStackSize(1);
    }

    public ItemBuilder maxDamage(int v) {
        this.maxDamage = v;
        return this;
    }

    public ItemBuilder containerItem(@ID String id) {
        this.containerItem = UtilsJS.getID(id);
        return this;
    }

    public ItemBuilder tool(ToolType type, int level) {
        this.tools.put(type, level);
        return this;
    }

    public ItemBuilder rarity(Rarity v) {
        this.rarity = v;
        return this;
    }

    public ItemBuilder glow(boolean v) {
        this.glow = v;
        return this;
    }

    public ItemBuilder tooltip(Object text) {
        this.tooltip.add(Text.of(text));
        return this;
    }

    public ItemBuilder group(String g) {
        for (ItemGroup ig : ItemGroup.field_78032_a) {
            if (!ig.func_200300_c().equals(g)) continue;
            this.group = ig;
            return this;
        }
        return this;
    }

    public ItemBuilder color(int index, int c) {
        this.color.put(index, 0xFF000000 | c);
        return this;
    }

    public ItemBuilder texture(String tex) {
        this.texture = tex;
        return this;
    }

    public ItemBuilder parentModel(String m) {
        this.parentModel = m;
        return this;
    }

    public ItemBuilder food(Consumer<FoodBuilder> b) {
        this.foodBuilder = new FoodBuilder();
        b.accept(this.foodBuilder);
        return this;
    }

    public Item.Properties createItemProperties() {
        Item.Properties properties = new Item.Properties();
        properties.func_200916_a(this.group);
        properties.func_200918_c(this.maxDamage);
        properties.func_200917_a(this.maxStackSize);
        properties.func_208103_a(this.rarity);
        for (Map.Entry<ToolType, Integer> entry : this.tools.entrySet()) {
            properties.addToolType(entry.getKey(), entry.getValue().intValue());
        }
        Item item = (Item)ForgeRegistries.ITEMS.getValue(UtilsJS.getMCID(this.containerItem));
        if (item != null && item != Items.field_190931_a) {
            properties.func_200919_a(item);
        }
        if (this.foodBuilder != null) {
            properties.func_221540_a(this.foodBuilder.build());
        }
        return properties;
    }
}

