/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.item;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.latvian.kubejs.KubeJS;
import dev.latvian.kubejs.docs.ID;
import dev.latvian.kubejs.docs.MinecraftClass;
import dev.latvian.kubejs.item.BoundItemStackJS;
import dev.latvian.kubejs.item.EmptyItemStackJS;
import dev.latvian.kubejs.item.UnboundItemStackJS;
import dev.latvian.kubejs.item.ingredient.GroupIngredientJS;
import dev.latvian.kubejs.item.ingredient.IgnoreNBTIngredientJS;
import dev.latvian.kubejs.item.ingredient.IngredientJS;
import dev.latvian.kubejs.item.ingredient.ModIngredientJS;
import dev.latvian.kubejs.item.ingredient.TagIngredientJS;
import dev.latvian.kubejs.player.PlayerJS;
import dev.latvian.kubejs.text.Text;
import dev.latvian.kubejs.text.TextTranslate;
import dev.latvian.kubejs.util.JSObjectType;
import dev.latvian.kubejs.util.ListJS;
import dev.latvian.kubejs.util.MapJS;
import dev.latvian.kubejs.util.NBTSerializable;
import dev.latvian.kubejs.util.UtilsJS;
import dev.latvian.kubejs.util.WrappedJSObjectChangeListener;
import dev.latvian.kubejs.world.BlockContainerJS;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class ItemStackJS
implements IngredientJS,
NBTSerializable,
WrappedJSObjectChangeListener<MapJS> {
    private static List<ItemStackJS> cachedItemList;
    private static ListJS cachedItemListJS;
    private static ListJS cachedItemTypeListJS;
    private double chance = 1.0;

    public static ItemStackJS of(@Nullable Object o) {
        String s;
        if (o == null) {
            return EmptyItemStackJS.INSTANCE;
        }
        if (o instanceof ItemStackJS) {
            return (ItemStackJS)o;
        }
        if (o instanceof IngredientJS) {
            return ((IngredientJS)o).getFirst();
        }
        if (o instanceof ItemStack) {
            ItemStack stack = (ItemStack)o;
            return stack.func_190926_b() ? EmptyItemStackJS.INSTANCE : new BoundItemStackJS(stack);
        }
        if (o instanceof ResourceLocation) {
            return new UnboundItemStackJS((ResourceLocation)o);
        }
        if (o instanceof Item) {
            return new UnboundItemStackJS(((Item)o).getRegistryName());
        }
        if (o instanceof CharSequence) {
            String s2 = o.toString();
            if (s2.startsWith("#")) {
                return new TagIngredientJS(s2.substring(1)).getFirst();
            }
            if (s2.startsWith("@")) {
                return new ModIngredientJS(s2.substring(1)).getFirst();
            }
            if (s2.startsWith("%")) {
                ItemGroup group = ItemStackJS.findGroup(s2.substring(1));
                if (group == null) {
                    return EmptyItemStackJS.INSTANCE;
                }
                return new GroupIngredientJS(group).getFirst();
            }
            return new UnboundItemStackJS(new ResourceLocation(s2));
        }
        MapJS map = MapJS.of(o);
        if (map != null) {
            if (map.containsKey("item")) {
                UnboundItemStackJS stack = new UnboundItemStackJS(new ResourceLocation(KubeJS.appendModId(map.get("item").toString())));
                if (map.get("count") instanceof Number) {
                    ((ItemStackJS)stack).setCount(((Number)map.get("count")).intValue());
                }
                if (map.containsKey("nbt")) {
                    stack.nbt(map.get("nbt"));
                }
                return stack;
            }
            if (map.get("tag") instanceof CharSequence) {
                ItemStackJS stack = new TagIngredientJS(map.get("tag").toString()).getFirst();
                if (map.containsKey("count")) {
                    stack.setCount(UtilsJS.parseInt(map.get("count"), 1));
                }
                return stack;
            }
        }
        if ((s = String.valueOf(o).trim()).isEmpty() || s.equals("air")) {
            return EmptyItemStackJS.INSTANCE;
        }
        if (s.startsWith("#")) {
            return new TagIngredientJS(s.substring(1)).getFirst();
        }
        if (s.startsWith("@")) {
            return new ModIngredientJS(s.substring(1)).getFirst();
        }
        if (s.startsWith("%")) {
            ItemGroup group = ItemStackJS.findGroup(s.substring(1));
            if (group == null) {
                return EmptyItemStackJS.INSTANCE;
            }
            return new GroupIngredientJS(group).getFirst();
        }
        return new UnboundItemStackJS(new ResourceLocation(s));
    }

    public static ItemStackJS of(@Nullable Object o, @Nullable Object countOrNBT) {
        ItemStackJS stack = ItemStackJS.of(o);
        Object n = UtilsJS.wrap(countOrNBT, JSObjectType.ANY);
        if (n instanceof Number) {
            stack.setCount(((Number)n).intValue());
        } else if (n instanceof MapJS) {
            stack.nbt(n);
        }
        return stack;
    }

    public static ItemStackJS of(@Nullable Object o, int count, @Nullable Object nbt) {
        ItemStackJS stack = ItemStackJS.of(o);
        stack.setCount(count);
        stack.nbt(nbt);
        return stack;
    }

    public static ItemStackJS resultFromRecipeJson(@Nullable JsonElement json) {
        JsonObject o;
        if (json == null || json.isJsonNull()) {
            return EmptyItemStackJS.INSTANCE;
        }
        if (json.isJsonPrimitive()) {
            return ItemStackJS.of(json.getAsString());
        }
        if (json.isJsonObject() && (o = json.getAsJsonObject()).has("item")) {
            ItemStackJS stack = ItemStackJS.of(o.get("item").getAsString());
            if (o.has("count")) {
                stack.setCount(o.get("count").getAsInt());
            }
            if (o.has("nbt")) {
                JsonElement element = o.get("nbt");
                if (element.isJsonObject()) {
                    stack.nbt(element);
                } else {
                    try {
                        stack.nbt(JsonToNBT.func_180713_a((String)JSONUtils.func_151206_a((JsonElement)element, (String)"nbt")));
                    }
                    catch (CommandSyntaxException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            if (o.has("chance")) {
                stack.setChance(o.get("chance").getAsDouble());
            }
            return stack;
        }
        return EmptyItemStackJS.INSTANCE;
    }

    public static List<ItemStackJS> getList() {
        if (cachedItemList != null) {
            return cachedItemList;
        }
        LinkedHashSet<ItemStackJS> set = new LinkedHashSet<ItemStackJS>();
        NonNullList stackList = NonNullList.func_191196_a();
        for (Item item : ForgeRegistries.ITEMS) {
            try {
                item.func_150895_a(ItemGroup.field_78027_g, stackList);
            }
            catch (Throwable ex) {
                KubeJS.LOGGER.error("Failed to load item list from " + item.getRegistryName() + "/" + item.getClass().getName() + ": " + ex);
            }
        }
        for (ItemStack stack : stackList) {
            if (stack.func_190926_b()) continue;
            set.add(new BoundItemStackJS(stack).getCopy().count(1));
        }
        cachedItemList = Collections.unmodifiableList(Arrays.asList(set.toArray(new ItemStackJS[0])));
        return cachedItemList;
    }

    public static ListJS getListJS() {
        if (cachedItemListJS == null) {
            cachedItemListJS = Objects.requireNonNull(ListJS.of(ItemStackJS.getList()));
        }
        return cachedItemListJS;
    }

    public static void clearListCache() {
        cachedItemList = null;
        cachedItemListJS = null;
    }

    public static ListJS getTypeList() {
        if (cachedItemTypeListJS == null) {
            cachedItemTypeListJS = new ListJS();
            for (ResourceLocation id : ForgeRegistries.ITEMS.getKeys()) {
                cachedItemTypeListJS.add(id.toString());
            }
        }
        return cachedItemTypeListJS;
    }

    @Nullable
    public static ItemGroup findGroup(String id) {
        for (ItemGroup group : ItemGroup.field_78032_a) {
            if (!id.equals(group.func_200300_c())) continue;
            return group;
        }
        return null;
    }

    public abstract Item getItem();

    @MinecraftClass
    public abstract ItemStack getItemStack();

    @ID
    public String getId() {
        return this.getItem().getRegistryName().toString();
    }

    public abstract ItemStackJS getCopy();

    public abstract void setCount(int var1);

    @Override
    public abstract int getCount();

    @Override
    public final ItemStackJS count(int c) {
        this.setCount(c);
        return this;
    }

    public final ItemStackJS x(int c) {
        return this.count(c);
    }

    @Override
    public boolean isEmpty() {
        return this.getCount() <= 0;
    }

    public boolean isBlock() {
        return this.getItem() instanceof BlockItem;
    }

    public abstract MapJS getNbt();

    public final ItemStackJS nbt(@Nullable Object o) {
        MapJS nbt = MapJS.of(o);
        if (nbt != null) {
            this.getNbt().putAll(nbt);
        }
        return this;
    }

    public void setChance(double c) {
        this.chance = MathHelper.func_151237_a((double)c, (double)0.0, (double)1.0);
    }

    public double getChance() {
        return this.chance;
    }

    public final ItemStackJS chance(double c) {
        this.setChance(c);
        return this;
    }

    public Text getName() {
        return Text.of(this.getItemStack().func_200301_q());
    }

    public void setName(@Nullable Object displayName) {
        if (displayName == null || displayName instanceof String && displayName.toString().isEmpty()) {
            return;
        }
        Text t = Text.of(displayName);
        MapJS nbt = this.getNbt();
        if (t instanceof TextTranslate) {
            nbt.getOrNewMap("display").put("LocName", (Object)((TextTranslate)t).getKey());
        } else {
            String s = t.getFormattedString();
            if (s.endsWith("\u00a7r")) {
                s = s.substring(0, s.length() - 2);
            }
            nbt.getOrNewMap("display").put("Name", (Object)s);
        }
    }

    public final ItemStackJS name(String displayName) {
        this.setName(displayName);
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int count = this.getCount();
        double chance = this.getChance();
        MapJS nbt = this.getNbt();
        if (count > 1 || chance < 1.0 || !nbt.isEmpty()) {
            builder.append("item.of('");
            builder.append(this.getId());
            builder.append('\'');
            if (count > 1) {
                builder.append(", ");
                builder.append(count);
            }
            if (!nbt.isEmpty()) {
                builder.append(", ");
                builder.append(nbt);
            }
            builder.append(')');
            if (chance < 1.0) {
                builder.append(".chance(");
                builder.append(chance);
                builder.append(')');
            }
        } else {
            builder.append('\'');
            builder.append(this.getId());
            builder.append('\'');
        }
        return builder.toString();
    }

    @Override
    public boolean test(ItemStackJS stack) {
        return this.areItemsEqual(stack) && this.isNBTEqual(stack);
    }

    @Override
    public boolean testVanilla(ItemStack stack) {
        return this.areItemsEqual(stack) && this.isNBTEqual(stack);
    }

    @Override
    public Set<ItemStackJS> getStacks() {
        return Collections.singleton(this);
    }

    @Override
    public ItemStackJS getFirst() {
        return this.getCopy();
    }

    public int hashCode() {
        return Objects.hash(this.getItem(), this.getNbt());
    }

    public boolean equals(Object o) {
        if (o instanceof CharSequence) {
            return this.getId().equals(UtilsJS.getID(o.toString()));
        }
        if (o instanceof ItemStack) {
            ItemStack s = (ItemStack)o;
            return !s.func_190926_b() && this.areItemsEqual(s) && this.isNBTEqual(s);
        }
        ItemStackJS s = ItemStackJS.of(o);
        return !s.isEmpty() && this.areItemsEqual(s) && this.isNBTEqual(s);
    }

    public boolean strongEquals(Object o) {
        if (o instanceof CharSequence) {
            return this.getId().equals(UtilsJS.getID(o.toString())) && this.getCount() == 1 && this.getNbt().isEmpty();
        }
        if (o instanceof ItemStack) {
            ItemStack s = (ItemStack)o;
            return this.getCount() == s.func_190916_E() && this.areItemsEqual(s) && this.isNBTEqual(s);
        }
        ItemStackJS s = ItemStackJS.of(o);
        return this.getCount() == s.getCount() && this.areItemsEqual(s) && this.isNBTEqual(s);
    }

    public MapJS getEnchantments() {
        MapJS nbt = this.getNbt();
        String key = this.getItem() == Items.field_151134_bR ? "StoredEnchantments" : "Enchantments";
        MapJS enchantments = new MapJS();
        enchantments.changeListener = o -> {
            ListJS list = new ListJS(o.size());
            for (Map.Entry entry : o.entrySet()) {
                if (!(entry.getValue() instanceof Number) || ((Number)entry.getValue()).intValue() <= 0) continue;
                MapJS ench = new MapJS(2);
                ench.put("id", (Object)new ResourceLocation((String)entry.getKey()).toString());
                ench.put("lvl", entry.getValue());
                list.add(ench);
            }
            if (list.isEmpty()) {
                nbt.remove(key);
            } else {
                nbt.put(key, (Object)list);
            }
        };
        ListJS list = ListJS.of(nbt.get(key));
        if (list != null) {
            for (Object o2 : list) {
                MapJS m = MapJS.of(o2);
                if (m == null || !m.containsKey("id") || !m.containsKey("lvl")) continue;
                enchantments.put(m.get("id").toString(), m.get("lvl"));
            }
        }
        return enchantments;
    }

    public ItemStackJS enchant(Object enchantments) {
        this.getEnchantments().putAll(MapJS.of(enchantments));
        return this;
    }

    public String getMod() {
        return this.getItem().getRegistryName().func_110624_b();
    }

    public ListJS getLore() {
        MapJS nbt = this.getNbt();
        ListJS lore = new ListJS();
        lore.changeListener = o -> {
            if (lore.isEmpty()) {
                nbt.remove("Lore");
            } else {
                ListJS lore1 = new ListJS(lore.size());
                for (Object o1 : lore) {
                    lore1.add(ITextComponent.Serializer.func_150696_a((ITextComponent)Text.of(o1).component()));
                }
                nbt.put("Lore", (Object)lore1);
            }
        };
        ListJS list = ListJS.of(nbt.get("Lore"));
        if (list != null) {
            for (Object o2 : list) {
                try {
                    lore.add(ITextComponent.Serializer.func_150699_a((String)o2.toString()));
                }
                catch (JsonParseException jsonParseException) {}
            }
        }
        return lore;
    }

    public IgnoreNBTIngredientJS ignoreNBT() {
        return new IgnoreNBTIngredientJS(this);
    }

    public boolean areItemsEqual(ItemStackJS stack) {
        return this.getItem() == stack.getItem();
    }

    public boolean areItemsEqual(ItemStack stack) {
        return this.getItem() == stack.func_77973_b();
    }

    public boolean isNBTEqual(ItemStackJS stack) {
        return Objects.equals(this.getNbt(), stack.getNbt());
    }

    public boolean isNBTEqual(ItemStack stack) {
        MapJS nbt = this.getNbt();
        CompoundNBT nbt1 = stack.func_77978_p();
        if (nbt1 == null) {
            return nbt.isEmpty();
        }
        return Objects.equals(MapJS.nbt(nbt), nbt1);
    }

    public int getHarvestLevel(ToolType tool, @Nullable PlayerJS<?> player, @Nullable BlockContainerJS block) {
        ItemStack stack = this.getItemStack();
        return stack.func_77973_b().getHarvestLevel(stack, tool, player == null ? null : (PlayerEntity)player.minecraftPlayer, block == null ? null : block.getBlockState());
    }

    public int getHarvestLevel(ToolType tool) {
        return this.getHarvestLevel(tool, null, null);
    }

    @Override
    public JsonElement toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("item", this.getId());
        if (!this.getNbt().isEmpty()) {
            json.addProperty("type", "forge:nbt");
            json.addProperty("nbt", this.getNbt().toNBT().toString());
        }
        return json;
    }

    public JsonElement toResultJson() {
        JsonObject json = new JsonObject();
        json.addProperty("item", this.getId());
        json.addProperty("count", (Number)this.getCount());
        MapJS nbt = this.getNbt();
        if (!nbt.isEmpty()) {
            json.addProperty("nbt", nbt.toNBT().toString());
        }
        if (this.getChance() < 1.0) {
            json.addProperty("chance", (Number)this.getChance());
        }
        return json;
    }

    public CompoundNBT toNBT() {
        return this.getItemStack().serializeNBT();
    }

    @Override
    public void onChanged(@Nullable MapJS o) {
    }

    public String getItemGroup() {
        if (this.getItem().func_77640_w() == null) {
            return "";
        }
        return this.getItem().func_77640_w().func_200300_c();
    }
}

