/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.item;

import dev.latvian.kubejs.KubeJSObjects;
import dev.latvian.kubejs.block.BlockBuilder;
import dev.latvian.kubejs.fluid.BucketItemJS;
import dev.latvian.kubejs.fluid.FluidBuilder;
import dev.latvian.kubejs.item.BlockItemJS;
import dev.latvian.kubejs.item.ItemBuilder;
import dev.latvian.kubejs.item.ItemCraftedEventJS;
import dev.latvian.kubejs.item.ItemDestroyedEventJS;
import dev.latvian.kubejs.item.ItemEntityInteractEventJS;
import dev.latvian.kubejs.item.ItemJS;
import dev.latvian.kubejs.item.ItemLeftClickEventJS;
import dev.latvian.kubejs.item.ItemPickupEventJS;
import dev.latvian.kubejs.item.ItemRightClickEmptyEventJS;
import dev.latvian.kubejs.item.ItemRightClickEventJS;
import dev.latvian.kubejs.item.ItemSmeltedEventJS;
import dev.latvian.kubejs.item.ItemTossEventJS;
import dev.latvian.kubejs.player.InventoryChangedEventJS;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class KubeJSItemEventHandler {
    public void init() {
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Item.class, this::registry);
        MinecraftForge.EVENT_BUS.addListener(this::rightClick);
        MinecraftForge.EVENT_BUS.addListener(this::rightClickEmpty);
        MinecraftForge.EVENT_BUS.addListener(this::leftClickEmpty);
        MinecraftForge.EVENT_BUS.addListener(this::pickup);
        MinecraftForge.EVENT_BUS.addListener(this::toss);
        MinecraftForge.EVENT_BUS.addListener(this::entityInteract);
        MinecraftForge.EVENT_BUS.addListener(this::crafted);
        MinecraftForge.EVENT_BUS.addListener(this::smelted);
        MinecraftForge.EVENT_BUS.addListener(this::destroyed);
    }

    private void registry(RegistryEvent.Register<Item> event) {
        for (ItemBuilder itemBuilder : KubeJSObjects.ITEMS.values()) {
            itemBuilder.item = new ItemJS(itemBuilder);
            itemBuilder.item.setRegistryName(itemBuilder.id);
            event.getRegistry().register((IForgeRegistryEntry)itemBuilder.item);
        }
        for (BlockBuilder blockBuilder : KubeJSObjects.BLOCKS.values()) {
            if (blockBuilder.itemBuilder == null) continue;
            blockBuilder.itemBuilder.blockItem = new BlockItemJS(blockBuilder.itemBuilder);
            blockBuilder.itemBuilder.blockItem.setRegistryName(blockBuilder.id);
            event.getRegistry().register((IForgeRegistryEntry)blockBuilder.itemBuilder.blockItem);
        }
        for (FluidBuilder fluidBuilder : KubeJSObjects.FLUIDS.values()) {
            fluidBuilder.bucketItem = new BucketItemJS(fluidBuilder);
            fluidBuilder.bucketItem.setRegistryName(fluidBuilder.id.func_110624_b() + ":" + fluidBuilder.id.func_110623_a() + "_bucket");
            event.getRegistry().register((IForgeRegistryEntry)fluidBuilder.bucketItem);
        }
    }

    private void rightClick(PlayerInteractEvent.RightClickItem event) {
        if (new ItemRightClickEventJS(event).post("item.right_click")) {
            event.setCanceled(true);
        }
    }

    private void rightClickEmpty(PlayerInteractEvent.RightClickEmpty event) {
        new ItemRightClickEmptyEventJS(event).post("item.right_click_empty");
    }

    private void leftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
        new ItemLeftClickEventJS(event).post("item.left_click");
    }

    private void pickup(EntityItemPickupEvent event) {
        if (event.getPlayer() != null && event.getPlayer().field_70170_p != null && new ItemPickupEventJS(event).post("item.pickup")) {
            event.setCanceled(true);
        }
    }

    private void toss(ItemTossEvent event) {
        if (event.getPlayer() != null && event.getPlayer().field_70170_p != null && new ItemTossEventJS(event).post("item.toss")) {
            event.setCanceled(true);
        }
    }

    private void entityInteract(PlayerInteractEvent.EntityInteract event) {
        if (new ItemEntityInteractEventJS(event).post("item.entity_interact")) {
            event.setCanceled(true);
        }
    }

    private void crafted(PlayerEvent.ItemCraftedEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity && !event.getCrafting().func_190926_b()) {
            new ItemCraftedEventJS(event).post("item.crafted");
            new InventoryChangedEventJS((ServerPlayerEntity)event.getPlayer(), event.getCrafting(), -1).post("player.inventory.changed");
        }
    }

    private void smelted(PlayerEvent.ItemSmeltedEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity && !event.getSmelting().func_190926_b()) {
            new ItemSmeltedEventJS(event).post("item.smelted");
            new InventoryChangedEventJS((ServerPlayerEntity)event.getPlayer(), event.getSmelting(), -1).post("player.inventory.changed");
        }
    }

    private void destroyed(PlayerDestroyItemEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            new ItemDestroyedEventJS(event).post("item.destroyed");
        }
    }
}

