/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.item;

import dev.latvian.kubejs.docs.ID;
import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.util.MapJS;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class UnboundItemStackJS
extends ItemStackJS {
    private final String item;
    private final ResourceLocation itemRL;
    private int count;
    private MapJS nbt;
    private ItemStack cached;

    public UnboundItemStackJS(ResourceLocation i) {
        this.item = i.toString();
        this.itemRL = i;
        this.count = 1;
        this.nbt = null;
        this.cached = null;
    }

    @Override
    public Item getItem() {
        Item i = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(this.item));
        if (i != null) {
            return i;
        }
        return Items.field_190931_a;
    }

    @Override
    public ItemStack getItemStack() {
        if (this.cached == null) {
            Item i = this.getItem();
            if (i == Items.field_190931_a) {
                return ItemStack.field_190927_a;
            }
            this.cached = new ItemStack((IItemProvider)i, this.count);
            if (this.nbt != null) {
                this.cached.func_77982_d(MapJS.nbt(this.nbt));
            }
        }
        return this.cached;
    }

    @Override
    @ID
    public String getId() {
        return this.item;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() || this.getItem() == Items.field_190931_a;
    }

    @Override
    public ItemStackJS getCopy() {
        UnboundItemStackJS stack = new UnboundItemStackJS(this.itemRL);
        stack.count = this.count;
        stack.nbt = this.nbt == null ? null : this.nbt.copy();
        stack.setChance(this.getChance());
        return stack;
    }

    @Override
    public void setCount(int c) {
        this.count = MathHelper.func_76125_a((int)c, (int)0, (int)64);
        this.cached = null;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public MapJS getNbt() {
        if (this.nbt == null) {
            this.nbt = new MapJS();
            this.nbt.changeListener = this;
        }
        return this.nbt;
    }

    @Override
    public boolean areItemsEqual(ItemStackJS stack) {
        if (stack instanceof UnboundItemStackJS) {
            return this.itemRL.equals((Object)((UnboundItemStackJS)stack).itemRL);
        }
        return this.getItem() == stack.getItem();
    }

    @Override
    public boolean areItemsEqual(ItemStack stack) {
        return this.itemRL.equals((Object)stack.func_77973_b().getRegistryName());
    }

    @Override
    public void onChanged(@Nullable MapJS o) {
        this.cached = null;
    }
}

