/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.item.ingredient;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.kubejs.KubeJS;
import dev.latvian.kubejs.item.BoundItemStackJS;
import dev.latvian.kubejs.item.EmptyItemStackJS;
import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.item.ingredient.CustomIngredient;
import dev.latvian.kubejs.item.ingredient.FilteredIngredientJS;
import dev.latvian.kubejs.item.ingredient.GroupIngredientJS;
import dev.latvian.kubejs.item.ingredient.IngredientStackJS;
import dev.latvian.kubejs.item.ingredient.MatchAllIngredientJS;
import dev.latvian.kubejs.item.ingredient.MatchAnyIngredientJS;
import dev.latvian.kubejs.item.ingredient.ModIngredientJS;
import dev.latvian.kubejs.item.ingredient.NotIngredientJS;
import dev.latvian.kubejs.item.ingredient.RegexIngredientJS;
import dev.latvian.kubejs.item.ingredient.TagIngredientJS;
import dev.latvian.kubejs.item.ingredient.VanillaPredicate;
import dev.latvian.kubejs.util.JsonSerializable;
import dev.latvian.kubejs.util.ListJS;
import dev.latvian.kubejs.util.MapJS;
import dev.latvian.kubejs.util.UtilsJS;
import dev.latvian.kubejs.util.WrappedJS;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CraftingHelper;

@FunctionalInterface
public interface IngredientJS
extends JsonSerializable,
WrappedJS {
    public static IngredientJS of(@Nullable Object o) {
        if (o == null) {
            return EmptyItemStackJS.INSTANCE;
        }
        if (o instanceof IngredientJS) {
            return (IngredientJS)o;
        }
        if (o instanceof CharSequence) {
            Pattern reg;
            String s = o.toString();
            if (s.equals("*")) {
                return MatchAllIngredientJS.INSTANCE;
            }
            if (s.startsWith("#")) {
                return new TagIngredientJS(s.substring(1));
            }
            if (s.startsWith("@")) {
                return new ModIngredientJS(s.substring(1));
            }
            if (s.startsWith("%")) {
                ItemGroup group = ItemStackJS.findGroup(s.substring(1));
                if (group == null) {
                    return EmptyItemStackJS.INSTANCE;
                }
                if (group == ItemGroup.field_78027_g) {
                    return MatchAllIngredientJS.INSTANCE;
                }
                return new GroupIngredientJS(group);
            }
            if (s.startsWith("mod:")) {
                return new ModIngredientJS(s.substring(4));
            }
            if (s.startsWith("regex:") && (reg = UtilsJS.regex(s.substring(6), false)) != null) {
                return new RegexIngredientJS(reg);
            }
            reg = UtilsJS.regex(s, true);
            if (reg != null) {
                return new RegexIngredientJS(reg);
            }
            return ItemStackJS.of(KubeJS.appendModId(s));
        }
        ListJS list = ListJS.of(o);
        if (list != null) {
            MatchAnyIngredientJS l = new MatchAnyIngredientJS();
            for (Object o1 : list) {
                IngredientJS ingredient = IngredientJS.of(o1);
                if (ingredient == EmptyItemStackJS.INSTANCE) continue;
                l.ingredients.add(ingredient);
            }
            return l.ingredients.isEmpty() ? EmptyItemStackJS.INSTANCE : l;
        }
        MapJS map = MapJS.of(o);
        if (map != null) {
            if (map.containsKey("ingredient")) {
                IngredientJS in = IngredientJS.of(map.get("ingredient"));
                if (in.isEmpty()) {
                    return in;
                }
                IngredientStackJS stack = new IngredientStackJS(in, 1);
                if (map.containsKey("count")) {
                    stack.count(UtilsJS.parseInt(map.get("count"), 1));
                } else if (map.containsKey("amount")) {
                    stack.count(UtilsJS.parseInt(map.get("amount"), 1));
                    stack.countKey = "amount";
                }
                return stack;
            }
            if (map.containsKey("type")) {
                JsonObject json = map.toJson();
                try {
                    Ingredient ingredient = CraftingHelper.getIngredient((JsonElement)json);
                    return new CustomIngredient(ingredient, json);
                }
                catch (Exception ex) {
                    KubeJS.LOGGER.error("Failed to load ingredient " + json + ": " + ex.toString());
                    return EmptyItemStackJS.INSTANCE;
                }
            }
            if (map.containsKey("tag")) {
                return new TagIngredientJS(map.get("tag").toString());
            }
            if (map.containsKey("mod")) {
                return new ModIngredientJS(map.get("mod").toString());
            }
            if (map.containsKey("regex")) {
                return new RegexIngredientJS(Pattern.compile(map.get("regex").toString()));
            }
        }
        return ItemStackJS.of(o);
    }

    public static IngredientJS ingredientFromRecipeJson(JsonElement json) {
        if (json.isJsonArray()) {
            MatchAnyIngredientJS any = new MatchAnyIngredientJS();
            for (JsonElement e : json.getAsJsonArray()) {
                any.ingredients.add(IngredientJS.ingredientFromRecipeJson(e));
            }
            return any;
        }
        if (json.isJsonPrimitive()) {
            return IngredientJS.of(json.getAsString());
        }
        if (json.isJsonObject()) {
            JsonObject o = json.getAsJsonObject();
            if (o.has("ingredient")) {
                IngredientJS in = IngredientJS.ingredientFromRecipeJson(o.get("ingredient"));
                if (o.has("count")) {
                    return in.count(o.get("count").getAsInt());
                }
                if (o.has("amount") && (in = in.count(o.get("amount").getAsInt())) instanceof IngredientStackJS) {
                    ((IngredientStackJS)in).countKey = "amount";
                }
                return in;
            }
            if (o.has("type")) {
                try {
                    Ingredient ingredient = CraftingHelper.getIngredient((JsonElement)o);
                    return new CustomIngredient(ingredient, o);
                }
                catch (Exception ex) {
                    KubeJS.LOGGER.error("Failed to load ingredient " + o + ": " + ex.toString());
                    return EmptyItemStackJS.INSTANCE;
                }
            }
            if (o.has("tag")) {
                return new TagIngredientJS(o.get("tag").getAsString());
            }
            if (o.has("item")) {
                ItemStackJS stack = ItemStackJS.of(o.get("item").getAsString());
                if (o.has("count")) {
                    stack.setCount(o.get("count").getAsInt());
                }
                return stack;
            }
        }
        return EmptyItemStackJS.INSTANCE;
    }

    public boolean test(ItemStackJS var1);

    default public boolean testVanilla(ItemStack stack) {
        return this.test(new BoundItemStackJS(stack));
    }

    default public Predicate<ItemStack> getVanillaPredicate() {
        return new VanillaPredicate(this);
    }

    default public boolean isEmpty() {
        return this.getFirst().isEmpty();
    }

    default public Set<ItemStackJS> getStacks() {
        LinkedHashSet<ItemStackJS> set = new LinkedHashSet<ItemStackJS>();
        for (ItemStackJS stack : ItemStackJS.getList()) {
            if (!this.test(stack)) continue;
            set.add(stack.getCopy());
        }
        return set;
    }

    default public IngredientJS filter(IngredientJS filter) {
        return new FilteredIngredientJS(this, filter);
    }

    default public IngredientJS not() {
        return new NotIngredientJS(this);
    }

    default public ItemStackJS getFirst() {
        for (ItemStackJS stack : this.getStacks()) {
            if (stack.isEmpty()) continue;
            return stack.count(this.getCount());
        }
        return EmptyItemStackJS.INSTANCE;
    }

    default public IngredientJS count(int count) {
        if (count <= 0) {
            return EmptyItemStackJS.INSTANCE;
        }
        if (count == 1 || count == this.getCount()) {
            return this;
        }
        return new IngredientStackJS(this, count);
    }

    default public int getCount() {
        return 1;
    }

    @Override
    default public JsonElement toJson() {
        Set<ItemStackJS> set = this.getStacks();
        if (set.size() == 1) {
            return set.iterator().next().toJson();
        }
        JsonArray array = new JsonArray();
        for (ItemStackJS stackJS : set) {
            array.add(stackJS.toJson());
        }
        return array;
    }

    default public boolean anyStackMatches(IngredientJS ingredient) {
        for (ItemStackJS stack : this.getStacks()) {
            if (!ingredient.test(stack)) continue;
            return true;
        }
        return false;
    }
}

