/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.item.ingredient;

import dev.latvian.kubejs.item.EmptyItemStackJS;
import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.item.ingredient.IngredientJS;
import dev.latvian.kubejs.util.ListJS;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public class MatchAnyIngredientJS
implements IngredientJS,
Consumer<IngredientJS> {
    public final List<IngredientJS> ingredients = new ArrayList<IngredientJS>();

    public MatchAnyIngredientJS add(@Nullable Object ingredient) {
        IngredientJS i = IngredientJS.of(ingredient);
        if (i != EmptyItemStackJS.INSTANCE) {
            this.ingredients.add(i);
        }
        return this;
    }

    public MatchAnyIngredientJS addAll(Object ingredients) {
        for (Object o : ListJS.orSelf(ingredients)) {
            this.add(o);
        }
        return this;
    }

    @Override
    public boolean test(ItemStackJS stack) {
        if (stack.isEmpty()) {
            return false;
        }
        for (IngredientJS ingredient : this.ingredients) {
            if (!ingredient.test(stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<ItemStackJS> getStacks() {
        LinkedHashSet<ItemStackJS> set = new LinkedHashSet<ItemStackJS>();
        for (IngredientJS ingredient : this.ingredients) {
            set.addAll(ingredient.getStacks());
        }
        return set;
    }

    @Override
    public boolean isEmpty() {
        for (IngredientJS i : this.ingredients) {
            if (i.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void accept(IngredientJS ingredient) {
        this.ingredients.add(ingredient);
    }

    public String toString() {
        if (this.ingredients.isEmpty()) {
            return "[]";
        }
        Iterator<IngredientJS> it = this.ingredients.iterator();
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            IngredientJS e = it.next();
            sb.append(e);
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append('|');
        }
    }
}

