/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.item.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.kubejs.item.BoundItemStackJS;
import dev.latvian.kubejs.item.EmptyItemStackJS;
import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.item.ingredient.IngredientJS;
import dev.latvian.kubejs.util.UtilsJS;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public class TagIngredientJS
implements IngredientJS {
    private static final Map<String, ItemTags.Wrapper> TAG_CACHE = new HashMap<String, ItemTags.Wrapper>();
    private final String tag;
    private final ItemTags.Wrapper cachedTag;

    public TagIngredientJS(String t) {
        this.tag = UtilsJS.getID(t);
        this.cachedTag = TAG_CACHE.computeIfAbsent(this.tag, i -> new ItemTags.Wrapper(new ResourceLocation(i)));
    }

    public String getTag() {
        return this.tag;
    }

    @Override
    public boolean test(ItemStackJS stack) {
        return !stack.isEmpty() && this.cachedTag.func_199685_a_(stack.getItem());
    }

    @Override
    public boolean testVanilla(ItemStack stack) {
        return !stack.func_190926_b() && this.cachedTag.func_199685_a_(stack.func_77973_b());
    }

    @Override
    public Set<ItemStackJS> getStacks() {
        if (this.cachedTag.func_199885_a().size() > 0) {
            NonNullList list = NonNullList.func_191196_a();
            for (Item item : this.cachedTag.func_199885_a()) {
                item.func_150895_a(ItemGroup.field_78027_g, list);
            }
            LinkedHashSet<ItemStackJS> set = new LinkedHashSet<ItemStackJS>();
            for (ItemStack stack1 : list) {
                if (stack1.func_190926_b()) continue;
                set.add(new BoundItemStackJS(stack1));
            }
            return set;
        }
        return Collections.emptySet();
    }

    @Override
    public ItemStackJS getFirst() {
        if (this.cachedTag.func_199885_a().size() > 0) {
            NonNullList list = NonNullList.func_191196_a();
            for (Item item : this.cachedTag.func_199885_a()) {
                item.func_150895_a(ItemGroup.field_78027_g, list);
                for (ItemStack stack : list) {
                    if (stack.func_190926_b()) continue;
                    return new BoundItemStackJS(stack);
                }
                list.clear();
            }
        }
        return EmptyItemStackJS.INSTANCE;
    }

    @Override
    public boolean isEmpty() {
        return this.cachedTag.func_199885_a().isEmpty();
    }

    public String toString() {
        return "'#" + this.tag + "'";
    }

    @Override
    public JsonElement toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("tag", this.tag);
        return json;
    }

    @Override
    public boolean anyStackMatches(IngredientJS ingredient) {
        if (ingredient instanceof TagIngredientJS && this.tag.equals(((TagIngredientJS)ingredient).tag)) {
            return true;
        }
        return IngredientJS.super.anyStackMatches(ingredient);
    }
}

