/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.player;

import dev.latvian.kubejs.docs.ID;
import dev.latvian.kubejs.entity.EntityJS;
import dev.latvian.kubejs.player.PlayerJS;
import dev.latvian.kubejs.text.Text;
import dev.latvian.kubejs.text.TextString;
import dev.latvian.kubejs.util.MapJS;
import dev.latvian.kubejs.util.MessageSender;
import dev.latvian.kubejs.util.UtilsJS;
import dev.latvian.kubejs.world.WorldJS;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.registries.ForgeRegistries;

public class EntityArrayList
extends ArrayList<EntityJS>
implements MessageSender {
    private final WorldJS world;

    public EntityArrayList(WorldJS w, int size) {
        super(size);
        this.world = w;
    }

    public EntityArrayList(WorldJS w, Iterable<? extends Entity> c) {
        this(w, c instanceof Collection ? ((Collection)c).size() : 10);
        for (Entity entity : c) {
            this.add(this.world.getEntity(entity));
        }
    }

    public WorldJS getWorld() {
        return this.world;
    }

    @Override
    public Text getName() {
        return new TextString("EntityList");
    }

    @Override
    public Text getDisplayName() {
        return new TextString(this.toString()).lightPurple();
    }

    @Override
    public void tell(Object message) {
        ITextComponent component = Text.of(message).component();
        for (EntityJS entity : this) {
            entity.minecraftEntity.func_145747_a(component);
        }
    }

    @Override
    public void setStatusMessage(Object message) {
        ITextComponent component = Text.of(message).component();
        for (EntityJS entity : this) {
            if (!(entity.minecraftEntity instanceof ServerPlayerEntity)) continue;
            ((ServerPlayerEntity)entity.minecraftEntity).func_146105_b(component, true);
        }
    }

    @Override
    public int runCommand(String command) {
        int m = 0;
        for (EntityJS entity : this) {
            m = Math.max(m, entity.runCommand(command));
        }
        return m;
    }

    public void kill() {
        for (EntityJS entity : this) {
            entity.kill();
        }
    }

    public void playSound(@ID String id, float volume, float pitch) {
        SoundEvent event = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(UtilsJS.getMCID(id));
        if (event != null) {
            for (EntityJS entity : this) {
                entity.minecraftEntity.field_70170_p.func_184148_a(null, entity.getX(), entity.getY(), entity.getZ(), event, entity.minecraftEntity.func_184176_by(), volume, pitch);
            }
        }
    }

    public void playSound(@ID String id) {
        this.playSound(id, 1.0f, 1.0f);
    }

    public EntityArrayList filter(Predicate<EntityJS> filter) {
        if (this.isEmpty()) {
            return this;
        }
        EntityArrayList list = new EntityArrayList(this.world, this.size());
        for (EntityJS entity : this) {
            if (!filter.test(entity)) continue;
            list.add(entity);
        }
        return list;
    }

    public void sendData(String channel, @Nullable Object data) {
        CompoundNBT nbt = MapJS.nbt(data);
        for (EntityJS entity : this) {
            if (!(entity instanceof PlayerJS)) continue;
            ((PlayerJS)entity).sendData(channel, nbt);
        }
    }

    @Override
    public EntityJS getFirst() {
        return (EntityJS)this.get(0);
    }
}

