/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.player;

import dev.latvian.kubejs.KubeJS;
import dev.latvian.kubejs.player.AttachPlayerDataEvent;
import dev.latvian.kubejs.player.ChestEventJS;
import dev.latvian.kubejs.player.InventoryEventJS;
import dev.latvian.kubejs.player.InventoryListener;
import dev.latvian.kubejs.player.PlayerAdvancementEventJS;
import dev.latvian.kubejs.player.PlayerChatEventJS;
import dev.latvian.kubejs.player.ServerPlayerDataJS;
import dev.latvian.kubejs.player.SimplePlayerEventJS;
import dev.latvian.kubejs.server.ServerJS;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ChestContainer;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;

public class KubeJSPlayerEventHandler {
    public void init() {
        MinecraftForge.EVENT_BUS.addListener(this::loggedIn);
        MinecraftForge.EVENT_BUS.addListener(this::loggedOut);
        MinecraftForge.EVENT_BUS.addListener(this::cloned);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::tick);
        MinecraftForge.EVENT_BUS.addListener(this::chat);
        MinecraftForge.EVENT_BUS.addListener(this::advancement);
        MinecraftForge.EVENT_BUS.addListener(this::inventoryOpened);
        MinecraftForge.EVENT_BUS.addListener(this::inventoryClosed);
    }

    public void loggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (ServerJS.instance != null && event.getPlayer() instanceof ServerPlayerEntity) {
            ServerPlayerDataJS p = new ServerPlayerDataJS(ServerJS.instance, event.getPlayer().func_110124_au(), event.getPlayer().func_146103_bH().getName(), KubeJS.nextClientHasClientMod);
            KubeJS.nextClientHasClientMod = false;
            p.getServer().playerMap.put(p.getId(), p);
            MinecraftForge.EVENT_BUS.post((Event)new AttachPlayerDataEvent(p));
            new SimplePlayerEventJS(event.getPlayer()).post("player.logged_in");
            event.getPlayer().field_71069_bz.func_75132_a((IContainerListener)new InventoryListener((ServerPlayerEntity)event.getPlayer()));
        }
    }

    public void loggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (ServerJS.instance == null || !ServerJS.instance.playerMap.containsKey(event.getPlayer().func_110124_au())) {
            return;
        }
        new SimplePlayerEventJS(event.getPlayer()).post("player.logged_out");
        ServerJS.instance.playerMap.remove(event.getPlayer().func_110124_au());
    }

    public void cloned(PlayerEvent.Clone event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            event.getPlayer().field_71069_bz.func_75132_a((IContainerListener)new InventoryListener((ServerPlayerEntity)event.getPlayer()));
        }
    }

    public void tick(TickEvent.PlayerTickEvent event) {
        if (ServerJS.instance != null && event.phase == TickEvent.Phase.END) {
            new SimplePlayerEventJS(event.player).post("player.tick");
        }
    }

    public void chat(ServerChatEvent event) {
        if (new PlayerChatEventJS(event).post("player.chat")) {
            event.setCanceled(true);
        }
    }

    public void advancement(AdvancementEvent event) {
        new PlayerAdvancementEventJS(event).post("player.advancement");
    }

    public void inventoryOpened(PlayerContainerEvent.Open event) {
        if (event.getPlayer() instanceof ServerPlayerEntity && !(event.getContainer() instanceof PlayerContainer)) {
            event.getContainer().func_75132_a((IContainerListener)new InventoryListener((ServerPlayerEntity)event.getPlayer()));
        }
        new InventoryEventJS((PlayerContainerEvent)event).post("player.inventory.opened");
        if (event.getContainer() instanceof ChestContainer) {
            new ChestEventJS((PlayerContainerEvent)event).post("player.chest.opened");
        }
    }

    public void inventoryClosed(PlayerContainerEvent.Close event) {
        new InventoryEventJS((PlayerContainerEvent)event).post("player.inventory.closed");
        if (event.getContainer() instanceof ChestContainer) {
            new ChestEventJS((PlayerContainerEvent)event).post("player.chest.closed");
        }
    }
}

