/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.player;

import dev.latvian.kubejs.entity.EntityJS;
import dev.latvian.kubejs.entity.LivingEntityEventJS;
import dev.latvian.kubejs.integration.gamestages.GameStageKJSHelper;
import dev.latvian.kubejs.player.PlayerJS;
import dev.latvian.kubejs.player.ServerPlayerJS;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.fml.ModList;

public abstract class PlayerEventJS
extends LivingEntityEventJS {
    @Nullable
    public PlayerJS getPlayer() {
        EntityJS e = this.getEntity();
        if (e instanceof PlayerJS) {
            return (PlayerJS)e;
        }
        return null;
    }

    public boolean hasGameStage(String stage) {
        if (this.getPlayer() != null && ModList.get().isLoaded("gamestages")) {
            return GameStageKJSHelper.hasStage(this.getPlayer().minecraftPlayer, stage);
        }
        return false;
    }

    public void addGameStage(String stage) {
        if (ModList.get().isLoaded("gamestages")) {
            if (this.getPlayer() instanceof ServerPlayerJS) {
                GameStageKJSHelper.addStage((ServerPlayerEntity)((ServerPlayerJS)this.getPlayer()).minecraftPlayer, stage);
            }
        } else {
            this.getWorld().getSide().console.error("Can't add gamestage " + stage + ", GameStages mod isn't loaded!");
        }
    }

    public void removeGameStage(String stage) {
        if (ModList.get().isLoaded("gamestages")) {
            if (this.getPlayer() instanceof ServerPlayerJS) {
                GameStageKJSHelper.removeStage((ServerPlayerEntity)((ServerPlayerJS)this.getPlayer()).minecraftPlayer, stage);
            }
        } else {
            this.getWorld().getSide().console.error("Can't remove gamestage " + stage + ", GameStages mod isn't loaded!");
        }
    }
}

