/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.player;

import dev.latvian.kubejs.core.PlayerInteractionManagerKJS;
import dev.latvian.kubejs.docs.ID;
import dev.latvian.kubejs.net.KubeJSNet;
import dev.latvian.kubejs.net.MessageCloseOverlay;
import dev.latvian.kubejs.net.MessageOpenOverlay;
import dev.latvian.kubejs.net.MessageSendDataFromServer;
import dev.latvian.kubejs.player.AdvancementJS;
import dev.latvian.kubejs.player.PlayerJS;
import dev.latvian.kubejs.player.PlayerStatsJS;
import dev.latvian.kubejs.player.ServerPlayerDataJS;
import dev.latvian.kubejs.server.ServerJS;
import dev.latvian.kubejs.text.Text;
import dev.latvian.kubejs.text.TextTranslate;
import dev.latvian.kubejs.util.MapJS;
import dev.latvian.kubejs.util.Overlay;
import dev.latvian.kubejs.world.BlockContainerJS;
import dev.latvian.kubejs.world.ServerWorldJS;
import java.util.Date;
import javax.annotation.Nullable;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SHeldItemChangePacket;
import net.minecraft.server.management.ProfileBanEntry;
import net.minecraft.server.management.UserListEntry;
import net.minecraft.stats.StatisticsManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraft.world.IWorld;
import net.minecraftforge.fml.network.PacketDistributor;

public class ServerPlayerJS
extends PlayerJS<ServerPlayerEntity> {
    public final ServerJS server;
    private final boolean hasClientMod;

    public ServerPlayerJS(ServerPlayerDataJS d, ServerWorldJS w, ServerPlayerEntity p) {
        super(d, w, p);
        this.server = w.getServer();
        this.hasClientMod = d.hasClientMod();
    }

    @Override
    public PlayerStatsJS getStats() {
        return new PlayerStatsJS(this, (StatisticsManager)((ServerPlayerEntity)this.minecraftPlayer).func_147099_x());
    }

    @Override
    public void openOverlay(Overlay overlay) {
        KubeJSNet.MAIN.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)this.minecraftPlayer), (Object)new MessageOpenOverlay(overlay));
    }

    @Override
    public void closeOverlay(String overlay) {
        KubeJSNet.MAIN.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)this.minecraftPlayer), (Object)new MessageCloseOverlay(overlay));
    }

    @Override
    public boolean isMiningBlock() {
        return ((PlayerInteractionManagerKJS)((ServerPlayerEntity)this.minecraftPlayer).field_71134_c).isDestroyingBlockKJS();
    }

    public void setCreativeMode(boolean mode) {
        ((ServerPlayerEntity)this.minecraftPlayer).field_71134_c.func_73076_a(mode ? GameType.CREATIVE : GameType.SURVIVAL);
    }

    public void setGameMode(String mode) {
        if (mode.equals("survival")) {
            ((ServerPlayerEntity)this.minecraftPlayer).field_71134_c.func_73076_a(GameType.SURVIVAL);
        } else if (mode.equals("creative")) {
            ((ServerPlayerEntity)this.minecraftPlayer).field_71134_c.func_73076_a(GameType.CREATIVE);
        } else if (mode.equals("adventure")) {
            ((ServerPlayerEntity)this.minecraftPlayer).field_71134_c.func_73076_a(GameType.ADVENTURE);
        } else if (mode.equals("spectator")) {
            ((ServerPlayerEntity)this.minecraftPlayer).field_71134_c.func_73076_a(GameType.SPECTATOR);
        }
    }

    public boolean isOP() {
        return this.server.minecraftServer.func_184103_al().func_152596_g(((ServerPlayerEntity)this.minecraftPlayer).func_146103_bH());
    }

    public void kick(Object reason) {
        ((ServerPlayerEntity)this.minecraftPlayer).field_71135_a.func_194028_b(Text.of(reason).component());
    }

    public void kick() {
        this.kick(new TextTranslate("multiplayer.disconnect.kicked"));
    }

    public void ban(String banner, String reason, long expiresInMillis) {
        Date date = new Date();
        ProfileBanEntry userlistbansentry = new ProfileBanEntry(((ServerPlayerEntity)this.minecraftPlayer).func_146103_bH(), date, banner, new Date(date.getTime() + (expiresInMillis <= 0L ? 315569260000L : expiresInMillis)), reason);
        this.server.minecraftServer.func_184103_al().func_152608_h().func_152687_a((UserListEntry)userlistbansentry);
        this.kick(new TextTranslate("multiplayer.disconnect.banned"));
    }

    public boolean hasClientMod() {
        return this.hasClientMod;
    }

    public void unlockAdvancement(@ID String id) {
        AdvancementJS a = ServerJS.instance.getAdvancement(id);
        if (a != null) {
            AdvancementProgress advancementprogress = ((ServerPlayerEntity)this.minecraftPlayer).func_192039_O().func_192747_a(a.advancement);
            for (String s : advancementprogress.func_192107_d()) {
                ((ServerPlayerEntity)this.minecraftPlayer).func_192039_O().func_192750_a(a.advancement, s);
            }
        }
    }

    public void revokeAdvancement(@ID String id) {
        AdvancementProgress advancementprogress;
        AdvancementJS a = ServerJS.instance.getAdvancement(id);
        if (a != null && (advancementprogress = ((ServerPlayerEntity)this.minecraftPlayer).func_192039_O().func_192747_a(a.advancement)).func_192108_b()) {
            for (String s : advancementprogress.func_192102_e()) {
                ((ServerPlayerEntity)this.minecraftPlayer).func_192039_O().func_192744_b(a.advancement, s);
            }
        }
    }

    @Override
    public void setSelectedSlot(int index) {
        int p = this.getSelectedSlot();
        super.setSelectedSlot(index);
        int n = this.getSelectedSlot();
        if (p != n && ((ServerPlayerEntity)this.minecraftPlayer).field_71135_a != null) {
            ((ServerPlayerEntity)this.minecraftPlayer).field_71135_a.func_147359_a((IPacket)new SHeldItemChangePacket(n));
        }
    }

    @Override
    public void setMouseItem(Object item) {
        super.setMouseItem(item);
        if (((ServerPlayerEntity)this.minecraftPlayer).field_71135_a != null) {
            ((ServerPlayerEntity)this.minecraftPlayer).func_71113_k();
        }
    }

    @Override
    public void sendData(String channel, @Nullable Object data) {
        if (!channel.isEmpty()) {
            KubeJSNet.MAIN.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)this.minecraftPlayer), (Object)new MessageSendDataFromServer(channel, MapJS.nbt(data)));
        }
    }

    @Nullable
    public BlockContainerJS getSpawnLocation() {
        BlockPos pos = ((ServerPlayerEntity)this.minecraftPlayer).func_180470_cg();
        return pos == null ? null : new BlockContainerJS((IWorld)((ServerPlayerEntity)this.minecraftPlayer).field_70170_p, pos);
    }

    public void setSpawnLocation(BlockContainerJS c) {
        ((ServerPlayerEntity)this.minecraftPlayer).setSpawnPoint(c.getPos(), true, false, c.minecraftWorld.func_201675_m().func_186058_p());
    }
}

