/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.latvian.kubejs.core.RecipeManagerKJS;
import dev.latvian.kubejs.event.EventJS;
import dev.latvian.kubejs.item.EmptyItemStackJS;
import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.item.ingredient.IngredientJS;
import dev.latvian.kubejs.recipe.CustomRecipeTypeJS;
import dev.latvian.kubejs.recipe.RecipeFunction;
import dev.latvian.kubejs.recipe.RecipeJS;
import dev.latvian.kubejs.recipe.RecipeTypeJS;
import dev.latvian.kubejs.script.ScriptType;
import dev.latvian.kubejs.server.ServerSettings;
import dev.latvian.kubejs.util.DynamicMapJS;
import dev.latvian.kubejs.util.JsonUtilsJS;
import dev.latvian.kubejs.util.ListJS;
import dev.latvian.kubejs.util.MapJS;
import dev.latvian.kubejs.util.UtilsJS;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class RecipeEventJS
extends EventJS {
    public static RecipeEventJS instance;
    private static final Predicate<RecipeJS> ALWAYS_TRUE;
    private static final Predicate<RecipeJS> ALWAYS_FALSE;
    public final Map<ResourceLocation, RecipeTypeJS> typeMap;
    public final List<RecipeJS> originalRecipes;
    private final List<RecipeJS> addedRecipes;
    private final Set<RecipeJS> removedRecipes;
    public final DynamicMapJS<ResourceLocation, RecipeFunction> functionMap;
    private final DynamicMapJS<String, DynamicMapJS<String, RecipeFunction>> recipeFunctions;

    public RecipeEventJS(Map<ResourceLocation, RecipeTypeJS> t) {
        this.typeMap = t;
        this.originalRecipes = new ArrayList<RecipeJS>();
        ScriptType.SERVER.console.info("Scanning recipes...");
        this.addedRecipes = new ArrayList<RecipeJS>();
        this.removedRecipes = new HashSet<RecipeJS>();
        this.functionMap = new DynamicMapJS<ResourceLocation, RecipeFunction>(id -> {
            IRecipeSerializer serializer = (IRecipeSerializer)ForgeRegistries.RECIPE_SERIALIZERS.getValue(id);
            if (serializer != null) {
                RecipeTypeJS typeJS = this.typeMap.get(serializer.getRegistryName());
                return new RecipeFunction(this, (ResourceLocation)id, typeJS != null ? typeJS : new CustomRecipeTypeJS(serializer));
            }
            return new RecipeFunction(this, (ResourceLocation)id, null);
        });
        this.recipeFunctions = new DynamicMapJS<String, DynamicMapJS>(n -> new DynamicMapJS<String, RecipeFunction>(p -> this.functionMap.get(new ResourceLocation(n, p))));
    }

    public void post(RecipeManager recipeManager, Map<ResourceLocation, JsonObject> jsonMap) {
        ScriptType.SERVER.console.setLineNumber(true);
        for (Map.Entry<ResourceLocation, JsonObject> entry : jsonMap.entrySet()) {
            ResourceLocation recipeId = entry.getKey();
            if (recipeId.func_110623_a().startsWith("_")) continue;
            JsonObject json = entry.getValue();
            try {
                if (!CraftingHelper.processConditions((JsonObject)json, (String)"conditions")) {
                    ScriptType.SERVER.console.info("Skipping loading recipe " + recipeId + " as it's conditions were not met");
                    continue;
                }
                JsonElement t = json.get("type");
                if (!(t instanceof JsonPrimitive) || !((JsonPrimitive)t).isString()) {
                    ScriptType.SERVER.console.warn("Missing or invalid recipe recipe type, expected a string in recipe " + recipeId);
                    continue;
                }
                RecipeFunction function = this.functionMap.get(new ResourceLocation(t.getAsString()));
                if (function.type == null) {
                    ScriptType.SERVER.console.warn("Skipping loading recipe " + recipeId + " as it's type " + function.typeID + " is unknown");
                    continue;
                }
                RecipeJS r = function.type.factory.get();
                r.id = recipeId;
                r.type = function.type;
                r.json = json;
                r.originalRecipe = function.type.serializer.func_199425_a_(recipeId, json);
                if (r.originalRecipe == null) {
                    ScriptType.SERVER.console.warn("Skipping loading recipe " + r + " as it's serializer returned null");
                    continue;
                }
                r.deserialize();
                this.originalRecipes.add(r);
                if (r.originalRecipe.func_192399_d()) {
                    ScriptType.SERVER.console.debug("Loaded recipe " + r + ": <dynamic>");
                    continue;
                }
                ScriptType.SERVER.console.debug("Loaded recipe " + r + ": " + r.inputItems + " -> " + r.outputItems);
            }
            catch (Exception ex) {
                ScriptType.SERVER.console.error("Parsing error loading recipe " + recipeId + ": " + ex);
            }
        }
        ScriptType.SERVER.console.info("Found " + this.originalRecipes.size() + " recipes");
        ScriptType.SERVER.console.setLineNumber(true);
        this.post(ScriptType.SERVER, "recipes");
        this.post(ScriptType.SERVER, "server.datapack.recipes");
        ScriptType.SERVER.console.setLineNumber(false);
        HashMap newRecipeMap = new HashMap();
        int removed = 0;
        int modified = 0;
        int added = 0;
        for (RecipeJS r : this.originalRecipes) {
            if (this.removedRecipes.contains(r)) {
                ++removed;
                continue;
            }
            if (r.originalRecipe == null) {
                try {
                    r.serialize();
                    r.originalRecipe = r.type.serializer.func_199425_a_(r.id, r.json);
                    ++modified;
                }
                catch (Exception ex) {
                    ScriptType.SERVER.console.warn("Error parsing recipe " + r + ": " + ex);
                }
            }
            if (r.originalRecipe == null) continue;
            newRecipeMap.computeIfAbsent(r.originalRecipe.func_222127_g(), type -> new HashMap()).put(r.id, r.originalRecipe);
        }
        for (RecipeJS r : this.addedRecipes) {
            try {
                r.serialize();
                r.originalRecipe = r.type.serializer.func_199425_a_(r.id, r.json);
                ++added;
                newRecipeMap.computeIfAbsent(r.originalRecipe.func_222127_g(), type -> new HashMap()).put(r.id, r.originalRecipe);
            }
            catch (Exception ex) {
                ScriptType.SERVER.console.warn("Error creating recipe " + r + ": " + ex);
            }
        }
        ((RecipeManagerKJS)recipeManager).setRecipesKJS(newRecipeMap);
        ScriptType.SERVER.console.info("Added " + added + " recipes, removed " + removed + " recipes, modified " + modified + " recipes");
    }

    public DynamicMapJS<String, DynamicMapJS<String, RecipeFunction>> getRecipes() {
        return this.recipeFunctions;
    }

    public RecipeJS addRecipe(RecipeJS r, RecipeTypeJS type, ListJS args1) {
        this.addedRecipes.add(r);
        if (r.id == null) {
            ResourceLocation itemId = UtilsJS.getMCID(r.outputItems.isEmpty() ? EmptyItemStackJS.INSTANCE.getId() : r.outputItems.get(0).getId());
            r.id = new ResourceLocation(type.serializer.getRegistryName().func_110624_b(), "kubejs_generated_" + this.addedRecipes.size() + "_" + itemId.func_110624_b() + "_" + itemId.func_110623_a().replace('/', '_'));
        }
        if (ServerSettings.instance.logAddedRecipes) {
            ScriptType.SERVER.console.info("+ " + r + ": " + r.inputItems + " -> " + r.outputItems);
        } else {
            ScriptType.SERVER.console.debug("+ " + r + ": " + r.inputItems + " -> " + r.outputItems);
        }
        return r;
    }

    public Predicate<RecipeJS> createFilter(@Nullable Object o) {
        if (o == null || o == ALWAYS_TRUE) {
            return ALWAYS_TRUE;
        }
        if (o == ALWAYS_FALSE) {
            return ALWAYS_FALSE;
        }
        ListJS list = ListJS.orSelf(o);
        if (list.isEmpty()) {
            return ALWAYS_TRUE;
        }
        if (list.size() > 1) {
            Predicate<RecipeJS> predicate = ALWAYS_FALSE;
            for (Object o1 : list) {
                Predicate<RecipeJS> p = this.createFilter(o1);
                if (p == ALWAYS_TRUE) {
                    return ALWAYS_TRUE;
                }
                if (p == ALWAYS_FALSE) continue;
                predicate = predicate.or(p);
            }
            return predicate;
        }
        MapJS map = MapJS.of(list.get(0));
        if (map == null || map.isEmpty()) {
            return ALWAYS_TRUE;
        }
        boolean exact = Boolean.TRUE.equals(map.get("exact"));
        Predicate<RecipeJS> predicate = ALWAYS_TRUE;
        if (map.get("or") != null) {
            predicate = predicate.and(this.createFilter(map.get("or")));
        }
        if (map.get("id") != null) {
            ResourceLocation id = UtilsJS.getMCID(map.get("id").toString());
            predicate = predicate.and(recipe -> recipe.id.equals((Object)id));
        }
        if (map.get("type") != null) {
            ResourceLocation type = UtilsJS.getMCID(map.get("type").toString());
            predicate = predicate.and(recipe -> type.equals((Object)recipe.type.serializer.getRegistryName()));
        }
        if (map.get("group") != null) {
            String group = map.get("group").toString();
            predicate = predicate.and(recipe -> recipe.getGroup().equals(group));
        }
        if (map.get("mod") != null) {
            String mod = map.get("mod").toString();
            predicate = predicate.and(recipe -> recipe.id.func_110624_b().equals(mod));
        }
        if (map.get("input") != null) {
            IngredientJS in = IngredientJS.of(map.get("input"));
            predicate = predicate.and(recipe -> recipe.hasInput(in, exact));
        }
        if (map.get("output") != null) {
            IngredientJS out = IngredientJS.of(map.get("output"));
            predicate = predicate.and(recipe -> recipe.hasOutput(out, exact));
        }
        return predicate;
    }

    public Predicate<RecipeJS> customFilter(Predicate<RecipeJS> filter) {
        return filter;
    }

    public void forEachRecipe(@Nullable Object o, Consumer<RecipeJS> consumer) {
        Predicate<RecipeJS> filter = this.createFilter(o);
        if (filter == ALWAYS_TRUE) {
            this.originalRecipes.forEach(consumer);
        } else if (filter != ALWAYS_FALSE) {
            this.originalRecipes.stream().filter(filter).forEach(consumer);
        }
    }

    public int remove(Object filter) {
        int[] count = new int[1];
        this.forEachRecipe(filter, r -> {
            if (this.removedRecipes.add((RecipeJS)r)) {
                if (ServerSettings.instance.logRemovedRecipes) {
                    ScriptType.SERVER.console.info("- " + r + ": " + r.inputItems + " -> " + r.outputItems);
                } else {
                    ScriptType.SERVER.console.debug("- " + r + ": " + r.inputItems + " -> " + r.outputItems);
                }
                count[0] = count[0] + 1;
            }
        });
        return count[0];
    }

    public int replaceInput(Object filter, Object ingredient, Object with, boolean exact) {
        int[] count = new int[1];
        IngredientJS i = IngredientJS.of(ingredient);
        IngredientJS w = IngredientJS.of(with);
        String is = i.toString();
        String ws = w.toString();
        this.forEachRecipe(filter, r -> {
            if (r.replaceInput(i, w, exact)) {
                count[0] = count[0] + 1;
                if (ServerSettings.instance.logAddedRecipes || ServerSettings.instance.logRemovedRecipes) {
                    ScriptType.SERVER.console.info("~ " + r + ": OUT " + is + " -> " + ws);
                }
            }
        });
        return count[0];
    }

    public int replaceInput(Object filter, Object ingredient, Object with) {
        return this.replaceInput(filter, ingredient, with, false);
    }

    public int replaceInput(Object ingredient, Object with) {
        return this.replaceInput(ALWAYS_TRUE, ingredient, with);
    }

    public int replaceOutput(Object filter, Object ingredient, Object with, boolean exact) {
        int[] count = new int[1];
        IngredientJS i = IngredientJS.of(ingredient);
        ItemStackJS w = ItemStackJS.of(with);
        String is = i.toString();
        String ws = w.toString();
        this.forEachRecipe(filter, r -> {
            if (r.replaceOutput(i, w, exact)) {
                count[0] = count[0] + 1;
                if (ServerSettings.instance.logAddedRecipes || ServerSettings.instance.logRemovedRecipes) {
                    ScriptType.SERVER.console.info("~ " + r + ": IN " + is + " -> " + ws);
                }
            }
        });
        return count[0];
    }

    public int replaceOutput(Object filter, Object ingredient, Object with) {
        return this.replaceOutput(filter, ingredient, with, false);
    }

    public int replaceOutput(Object ingredient, Object with) {
        return this.replaceOutput(ALWAYS_TRUE, ingredient, with);
    }

    public RecipeFunction getShaped() {
        return this.functionMap.get(IRecipeSerializer.field_222157_a.getRegistryName());
    }

    public RecipeFunction getShapeless() {
        return this.functionMap.get(IRecipeSerializer.field_222158_b.getRegistryName());
    }

    public RecipeFunction getSmelting() {
        return this.functionMap.get(IRecipeSerializer.field_222171_o.getRegistryName());
    }

    public void printTypes() {
        ScriptType.SERVER.console.info("== All recipe types ==");
        HashSet list = new HashSet();
        this.originalRecipes.forEach(r -> list.add(r.type.toString()));
        list.stream().sorted().forEach(ScriptType.SERVER.console::info);
        ScriptType.SERVER.console.info(list.size() + " types");
    }

    public void printExamples(String type) {
        List list = this.originalRecipes.stream().filter(recipeJS -> recipeJS.type.toString().equals(type)).collect(Collectors.toList());
        Collections.shuffle(list);
        ScriptType.SERVER.console.info("== Random examples of '" + type + "' ==");
        for (int i = 0; i < Math.min(list.size(), 5); ++i) {
            RecipeJS r = (RecipeJS)list.get(i);
            ScriptType.SERVER.console.info("- " + r.id + ":\n" + JsonUtilsJS.toPrettyString((JsonElement)r.json));
        }
    }

    static {
        ALWAYS_TRUE = r -> true;
        ALWAYS_FALSE = r -> false;
    }
}

