/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.latvian.kubejs.docs.ID;
import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.item.ingredient.IngredientJS;
import dev.latvian.kubejs.recipe.RecipeTypeJS;
import dev.latvian.kubejs.util.ListJS;
import dev.latvian.kubejs.util.UtilsJS;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;

public abstract class RecipeJS {
    public ResourceLocation id;
    public RecipeTypeJS type;
    public JsonObject json = null;
    public IRecipe<?> originalRecipe = null;
    public final List<IngredientJS> inputItems = new ArrayList<IngredientJS>(1);
    public final List<ItemStackJS> outputItems = new ArrayList<ItemStackJS>(1);

    public abstract void create(ListJS var1);

    public abstract void deserialize();

    public abstract void serialize();

    public final void save() {
        this.originalRecipe = null;
    }

    public RecipeJS id(@ID String _id) {
        this.id = UtilsJS.getMCID(_id);
        return this;
    }

    public RecipeJS group(@ID String g) {
        this.setGroup(g);
        return this;
    }

    public final boolean hasInput(IngredientJS ingredient, boolean exact) {
        for (IngredientJS in : this.inputItems) {
            if (!(exact ? in.equals(ingredient) : in.anyStackMatches(ingredient))) continue;
            return true;
        }
        return false;
    }

    public final boolean replaceInput(IngredientJS i, IngredientJS with, boolean exact) {
        boolean changed = false;
        for (int j = 0; j < this.inputItems.size(); ++j) {
            if (!(exact ? this.inputItems.get(j).equals(i) : this.inputItems.get(j).anyStackMatches(i))) continue;
            this.inputItems.set(j, IngredientJS.of(with));
            changed = true;
            this.save();
        }
        return changed;
    }

    public final boolean hasOutput(IngredientJS ingredient, boolean exact) {
        for (ItemStackJS out : this.outputItems) {
            if (!(exact ? ingredient.equals(out) : ingredient.test(out))) continue;
            return true;
        }
        return false;
    }

    public final boolean replaceOutput(IngredientJS i, ItemStackJS with, boolean exact) {
        boolean changed = false;
        for (int j = 0; j < this.outputItems.size(); ++j) {
            if (!(exact ? i.equals(this.outputItems.get(j)) : i.test(this.outputItems.get(j)))) continue;
            this.outputItems.set(j, with.getCopy().count(this.outputItems.get(j).getCount())).chance(this.outputItems.get(j).getChance());
            changed = true;
            this.save();
        }
        return changed;
    }

    @ID
    public String getGroup() {
        JsonElement e = this.json.get("group");
        return e instanceof JsonPrimitive ? e.getAsString() : "";
    }

    public void setGroup(@ID String g) {
        if (g.isEmpty()) {
            this.json.remove("group");
        } else {
            this.json.addProperty("group", g);
        }
        this.save();
    }

    public String toString() {
        return this.id + "[" + this.type + "]";
    }

    @ID
    public String getId() {
        return this.id.toString();
    }

    public String getMod() {
        return this.id.func_110624_b();
    }

    public String getPath() {
        return this.id.func_110623_a();
    }

    @ID
    public String getType() {
        return this.type.toString();
    }
}

