/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.recipe.mekanism;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.item.ingredient.IngredientJS;
import dev.latvian.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.kubejs.recipe.RecipeJS;
import dev.latvian.kubejs.util.ListJS;
import java.util.ArrayList;
import java.util.List;

public class MekanismMachineRecipeJS
extends RecipeJS {
    public List<Integer> inputAmount = new ArrayList<Integer>();
    private String inputName = "input";
    private String outputName = "output";

    @Override
    public void create(ListJS args) {
        ItemStackJS output = ItemStackJS.of(args.get(0));
        if (output.isEmpty()) {
            throw new RecipeExceptionJS("Mekanism machine recipe result can't be empty!");
        }
        this.outputItems.add(output);
        ListJS in = ListJS.orSelf(args.get(1));
        for (Object o : in) {
            IngredientJS i = IngredientJS.of(o);
            if (i.isEmpty()) continue;
            int c = i.getCount();
            if (c > 1) {
                this.inputItems.add(i.count(1));
                this.inputAmount.add(c);
                continue;
            }
            this.inputItems.add(i);
            this.inputAmount.add(1);
        }
        if (this.inputItems.isEmpty()) {
            throw new RecipeExceptionJS("Mekanism machine recipe ingredient " + args.get(1) + " is not a valid ingredient!");
        }
    }

    @Override
    public void deserialize() {
        JsonObject o;
        IngredientJS i;
        ItemStackJS output = ItemStackJS.resultFromRecipeJson(this.json.get("output"));
        if (output.isEmpty()) {
            output = ItemStackJS.resultFromRecipeJson(this.json.get("mainOutput"));
            if (output.isEmpty()) {
                throw new RecipeExceptionJS("Mekanism machine recipe result can't be empty!");
            }
            this.outputName = "mainOutput";
        }
        this.outputItems.add(output);
        JsonElement in = this.json.get("input");
        if (in == null || in.isJsonNull()) {
            in = this.json.get("itemInput");
            this.inputName = "itemInput";
        }
        if (in instanceof JsonArray) {
            for (JsonElement e : (JsonArray)in) {
                JsonObject o2 = e.getAsJsonObject();
                IngredientJS i2 = IngredientJS.ingredientFromRecipeJson(o2.get("ingredient"));
                if (i2.isEmpty()) continue;
                this.inputItems.add(i2.count(1));
                if (o2.has("amount")) {
                    this.inputAmount.add(o2.get("amount").getAsInt());
                    continue;
                }
                this.inputAmount.add(1);
            }
        } else if (in instanceof JsonObject && !(i = IngredientJS.ingredientFromRecipeJson((o = in.getAsJsonObject()).get("ingredient"))).isEmpty()) {
            this.inputItems.add(i.count(1));
            if (o.has("amount")) {
                this.inputAmount.add(o.get("amount").getAsInt());
            } else {
                this.inputAmount.add(1);
            }
        }
        if (this.inputItems.isEmpty()) {
            throw new RecipeExceptionJS("Mekanism machine recipe ingredient " + this.json.get("ingredient") + " is not a valid ingredient!");
        }
    }

    @Override
    public void serialize() {
        if (this.inputItems.size() == 1) {
            JsonObject inputJson = new JsonObject();
            inputJson.add("ingredient", ((IngredientJS)this.inputItems.get(0)).toJson());
            inputJson.addProperty("amount", (Number)this.inputAmount.get(0));
            this.json.add(this.inputName, (JsonElement)inputJson);
        } else {
            JsonArray inputArray = new JsonArray();
            for (int i = 0; i < this.inputItems.size(); ++i) {
                JsonObject inputJson = new JsonObject();
                inputJson.add("ingredient", ((IngredientJS)this.inputItems.get(i)).toJson());
                inputJson.addProperty("amount", (Number)this.inputAmount.get(i));
                inputArray.add((JsonElement)inputJson);
            }
            this.json.add(this.inputName, (JsonElement)inputArray);
        }
        this.json.add(this.outputName, ((ItemStackJS)this.outputItems.get(0)).toResultJson());
    }
}

