/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.recipe.minecraft;

import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.item.ingredient.IngredientJS;
import dev.latvian.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.kubejs.recipe.RecipeJS;
import dev.latvian.kubejs.util.ListJS;

public class CookingRecipeJS
extends RecipeJS {
    @Override
    public void create(ListJS args) {
        ItemStackJS result = ItemStackJS.of(args.get(0));
        if (result.isEmpty()) {
            throw new RecipeExceptionJS("Cooking recipe result " + args.get(0) + " is not a valid item!");
        }
        this.outputItems.add(result);
        IngredientJS ingredient = IngredientJS.of(args.get(1));
        if (ingredient.isEmpty()) {
            throw new RecipeExceptionJS("Cooking recipe ingredient " + args.get(1) + " is not a valid ingredient!");
        }
        this.inputItems.add(ingredient);
        if (args.size() >= 3) {
            this.xp(((Number)args.get(2)).floatValue());
        }
        if (args.size() >= 4) {
            this.cookingTime(((Number)args.get(3)).intValue());
        }
    }

    @Override
    public void deserialize() {
        ItemStackJS result = ItemStackJS.resultFromRecipeJson(this.json.get("result"));
        if (result.isEmpty()) {
            throw new RecipeExceptionJS("Cooking recipe result " + this.json.get("result") + " is not a valid item!");
        }
        this.outputItems.add(result);
        IngredientJS ingredient = IngredientJS.ingredientFromRecipeJson(this.json.get("ingredient"));
        if (ingredient.isEmpty()) {
            throw new RecipeExceptionJS("Cooking recipe ingredient " + this.json.get("ingredient") + " is not a valid ingredient!");
        }
        this.inputItems.add(ingredient);
    }

    @Override
    public void serialize() {
        this.json.add("ingredient", ((IngredientJS)this.inputItems.get(0)).toJson());
        this.json.add("result", ((ItemStackJS)this.outputItems.get(0)).toResultJson());
    }

    public CookingRecipeJS xp(float xp) {
        this.json.addProperty("experience", (Number)Float.valueOf(Math.max(0.0f, xp)));
        return this;
    }

    public CookingRecipeJS cookingTime(int time) {
        this.json.addProperty("cookingtime", (Number)Math.max(0, time));
        return this;
    }
}

