/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.recipe.minecraft;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import dev.latvian.kubejs.item.EmptyItemStackJS;
import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.item.ingredient.IngredientJS;
import dev.latvian.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.kubejs.recipe.RecipeJS;
import dev.latvian.kubejs.script.ScriptType;
import dev.latvian.kubejs.util.ListJS;

public class CustomRecipeJS
extends RecipeJS {
    private String inputKey = "";
    private int inputType = -1;
    private String outputKey = "";
    private int outputType = -1;

    @Override
    public void create(ListJS args) {
        throw new RecipeExceptionJS("Can't create custom recipe for type " + this.id + "!");
    }

    private boolean addInput(String k) {
        JsonElement e = this.json.get(k);
        if (e == null || e.isJsonNull()) {
            return false;
        }
        if (e.isJsonArray()) {
            for (JsonElement e1 : e.getAsJsonArray()) {
                IngredientJS i = IngredientJS.ingredientFromRecipeJson(e1);
                if (i.isEmpty()) continue;
                this.inputItems.add(i);
            }
            this.inputKey = k;
            this.inputType = 1;
            return true;
        }
        IngredientJS i = IngredientJS.ingredientFromRecipeJson(e);
        if (!i.isEmpty()) {
            this.inputItems.add(i);
            this.inputKey = k;
            this.inputType = 0;
            return true;
        }
        return false;
    }

    private boolean addOutput(String k) {
        JsonElement e = this.json.get(k);
        if (e == null || e.isJsonNull()) {
            return false;
        }
        if (e.isJsonArray()) {
            for (JsonElement e1 : e.getAsJsonArray()) {
                ItemStackJS i = ItemStackJS.resultFromRecipeJson(e1);
                if (i.isEmpty()) continue;
                this.outputItems.add(i);
            }
            this.outputKey = k;
            this.outputType = 1;
            return true;
        }
        ItemStackJS i = ItemStackJS.resultFromRecipeJson(e);
        if (!i.isEmpty()) {
            if (e.isJsonPrimitive()) {
                this.outputType = 2;
                if (this.json.has("count")) {
                    i.count(this.json.get("count").getAsInt());
                }
            } else {
                this.outputType = 0;
            }
            this.outputKey = k;
            this.outputItems.add(i);
            return true;
        }
        return false;
    }

    @Override
    public void deserialize() {
        this.inputItems.clear();
        this.outputItems.clear();
        this.inputKey = "";
        this.inputType = -1;
        this.outputKey = "";
        this.outputType = -1;
        if (this.originalRecipe == null || this.originalRecipe.func_192399_d()) {
            return;
        }
        try {
            if (!(this.addInput("ingredient") || this.addInput("ingredients") || this.addInput("in") || this.addInput("input") || this.addInput("inputs") || this.addInput("itemInput") || this.addInput("infusionInput"))) {
                ScriptType.SERVER.console.debug("! " + this + ": Couldn't find any input items!");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (!(this.addOutput("result") || this.addOutput("results") || this.addOutput("out") || this.addOutput("output") || this.addOutput("outputs") || this.addOutput("itemOutput") || this.addOutput("mainOutput") || this.addOutput("secondaryOutput"))) {
                ScriptType.SERVER.console.debug("! " + this + ": Couldn't find any output items!");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void serialize() {
        JsonArray a;
        if (this.inputType != -1 && !this.inputKey.isEmpty()) {
            if (this.inputType == 1) {
                a = new JsonArray();
                for (IngredientJS in : this.inputItems) {
                    a.add(in.toJson());
                }
                this.json.add(this.inputKey, (JsonElement)a);
            } else if (this.inputType == 0) {
                this.json.add(this.inputKey, (this.inputItems.isEmpty() ? EmptyItemStackJS.INSTANCE : (IngredientJS)this.inputItems.get(0)).toJson());
            }
        }
        if (this.outputType != -1 && !this.outputKey.isEmpty()) {
            if (this.outputType == 1) {
                a = new JsonArray();
                for (IngredientJS in : this.outputItems) {
                    a.add(((ItemStackJS)in).toResultJson());
                }
                this.json.add(this.outputKey, (JsonElement)a);
            } else if (this.outputType == 2) {
                this.json.addProperty(this.outputKey, (this.outputItems.isEmpty() ? EmptyItemStackJS.INSTANCE : (ItemStackJS)this.outputItems.get(0)).getId());
                this.json.addProperty("count", (Number)(this.outputItems.isEmpty() ? EmptyItemStackJS.INSTANCE : (ItemStackJS)this.outputItems.get(0)).getCount());
            } else if (this.outputType == 0) {
                this.json.add(this.outputKey, (this.outputItems.isEmpty() ? EmptyItemStackJS.INSTANCE : (ItemStackJS)this.outputItems.get(0)).toResultJson());
            }
        }
    }
}

