/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.recipe.minecraft;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.item.ingredient.IngredientJS;
import dev.latvian.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.kubejs.recipe.RecipeJS;
import dev.latvian.kubejs.util.ListJS;
import dev.latvian.kubejs.util.MapJS;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ShapedRecipeJS
extends RecipeJS {
    private final List<String> pattern = new ArrayList<String>();
    private final List<String> key = new ArrayList<String>();

    @Override
    public void create(ListJS args) {
        if (args.size() < 3) {
            if (args.size() < 2) {
                throw new RecipeExceptionJS("Shaped recipe requires 3 arguments - result, pattern and keys!");
            }
            ItemStackJS result = ItemStackJS.of(args.get(0));
            if (result.isEmpty()) {
                throw new RecipeExceptionJS("Shaped recipe result " + args.get(0) + " is not a valid item!");
            }
            this.outputItems.add(result);
            ListJS vertical = ListJS.orSelf(args.get(1));
            if (vertical.isEmpty()) {
                throw new RecipeExceptionJS("Shaped recipe pattern is empty!");
            }
            int id = 0;
            for (Object o : vertical) {
                StringBuilder horizontalPattern = new StringBuilder();
                ListJS horizontal = ListJS.orSelf(o);
                for (Object item : horizontal) {
                    IngredientJS ingredient = IngredientJS.of(item);
                    if (!ingredient.isEmpty()) {
                        String currentId = String.valueOf((char)(65 + id++));
                        horizontalPattern.append(currentId);
                        this.inputItems.add(ingredient);
                        this.key.add(currentId);
                        continue;
                    }
                    horizontalPattern.append(" ");
                }
                this.pattern.add(horizontalPattern.toString());
            }
            return;
        }
        ItemStackJS result = ItemStackJS.of(args.get(0));
        if (result.isEmpty()) {
            throw new RecipeExceptionJS("Shaped recipe result " + args.get(0) + " is not a valid item!");
        }
        this.outputItems.add(result);
        ListJS pattern1 = ListJS.orSelf(args.get(1));
        if (pattern1.isEmpty()) {
            throw new RecipeExceptionJS("Shaped recipe pattern is empty!");
        }
        for (Object p : pattern1) {
            this.pattern.add(String.valueOf(p));
        }
        MapJS key1 = MapJS.of(args.get(2));
        if (key1 == null || key1.isEmpty()) {
            throw new RecipeExceptionJS("Shaped recipe key map is empty!");
        }
        for (String k : key1.keySet()) {
            IngredientJS i = IngredientJS.of(key1.get(k));
            if (!i.isEmpty()) {
                this.inputItems.add(i);
                this.key.add(k);
                continue;
            }
            throw new RecipeExceptionJS("Shaped recipe ingredient " + key1.get(k) + " with key '" + k + "' is not a valid ingredient!");
        }
    }

    @Override
    public void deserialize() {
        ItemStackJS result = ItemStackJS.resultFromRecipeJson(this.json.get("result"));
        if (result.isEmpty()) {
            throw new RecipeExceptionJS("Shaped recipe result " + this.json.get("result") + " is not a valid item!");
        }
        this.outputItems.add(result);
        for (JsonElement e : this.json.get("pattern").getAsJsonArray()) {
            this.pattern.add(e.getAsString());
        }
        if (this.pattern.isEmpty()) {
            throw new RecipeExceptionJS("Shaped recipe pattern is empty!");
        }
        for (Map.Entry entry : this.json.get("key").getAsJsonObject().entrySet()) {
            IngredientJS i = IngredientJS.ingredientFromRecipeJson((JsonElement)entry.getValue());
            if (!i.isEmpty()) {
                this.inputItems.add(i);
                this.key.add((String)entry.getKey());
                continue;
            }
            throw new RecipeExceptionJS("Shaped recipe ingredient " + entry.getValue() + " with key '" + (String)entry.getKey() + "' is not a valid ingredient!");
        }
        if (this.key.isEmpty()) {
            throw new RecipeExceptionJS("Shaped recipe key map is empty!");
        }
    }

    @Override
    public void serialize() {
        JsonArray patternJson = new JsonArray();
        for (String s : this.pattern) {
            patternJson.add(s);
        }
        this.json.add("pattern", (JsonElement)patternJson);
        JsonObject keyJson = new JsonObject();
        for (int i = 0; i < this.key.size(); ++i) {
            keyJson.add(this.key.get(i), ((IngredientJS)this.inputItems.get(i)).toJson());
        }
        this.json.add("key", (JsonElement)keyJson);
        this.json.add("result", ((ItemStackJS)this.outputItems.get(0)).toResultJson());
    }
}

