/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.recipe.minecraft;

import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.item.ingredient.IngredientJS;
import dev.latvian.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.kubejs.recipe.RecipeJS;
import dev.latvian.kubejs.util.ListJS;

public class StonecuttingRecipeJS
extends RecipeJS {
    @Override
    public void create(ListJS args) {
        ItemStackJS result = ItemStackJS.of(args.get(0));
        if (result.isEmpty()) {
            throw new RecipeExceptionJS("Stonecutting recipe result " + args.get(0) + " is not a valid item!");
        }
        this.outputItems.add(result);
        IngredientJS ingredient = IngredientJS.of(args.get(1));
        if (ingredient.isEmpty()) {
            throw new RecipeExceptionJS("Stonecutting recipe ingredient " + args.get(1) + " is not a valid ingredient!");
        }
        this.inputItems.add(ingredient);
    }

    @Override
    public void deserialize() {
        ItemStackJS result = ItemStackJS.resultFromRecipeJson(this.json.get("result"));
        if (result.isEmpty()) {
            throw new RecipeExceptionJS("Stonecutting recipe result " + this.json.get("result") + " is not a valid item!");
        }
        this.outputItems.add(result);
        IngredientJS ingredient = IngredientJS.ingredientFromRecipeJson(this.json.get("ingredient"));
        if (ingredient.isEmpty()) {
            throw new RecipeExceptionJS("Stonecutting recipe ingredient " + this.json.get("ingredient") + " is not a valid ingredient!");
        }
        this.inputItems.add(ingredient);
    }

    @Override
    public void serialize() {
        this.json.add("ingredient", ((IngredientJS)this.inputItems.get(0)).toJson());
        this.json.addProperty("result", ((ItemStackJS)this.outputItems.get(0)).getId());
        this.json.addProperty("count", (Number)((ItemStackJS)this.outputItems.get(0)).getCount());
    }
}

