/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.recipe.silentsmek;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.item.ingredient.IngredientJS;
import dev.latvian.kubejs.item.ingredient.MatchAnyIngredientJS;
import dev.latvian.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.kubejs.recipe.RecipeJS;
import dev.latvian.kubejs.util.ListJS;
import java.util.ArrayList;
import java.util.List;

public class SilentsMechanmismsAlloySmeltingRecipeJS
extends RecipeJS {
    public List<Integer> inputCount = new ArrayList<Integer>();
    public int processTime = 400;

    @Override
    public void create(ListJS args) {
        ItemStackJS output = ItemStackJS.of(args.get(0));
        if (output.isEmpty()) {
            throw new RecipeExceptionJS("Silents Mechanisms alloy smelting recipe result can't be empty!");
        }
        this.outputItems.add(output);
        ListJS in = ListJS.orSelf(args.get(1));
        for (Object o : in) {
            IngredientJS i = IngredientJS.of(o);
            if (i.isEmpty()) continue;
            int c = i.getCount();
            if (c > 1) {
                this.inputItems.add(i.count(1));
                this.inputCount.add(c);
                continue;
            }
            this.inputItems.add(i);
            this.inputCount.add(1);
        }
        if (this.inputItems.isEmpty()) {
            throw new RecipeExceptionJS("Silents Mechanisms alloy smelting recipe ingredient " + args.get(1) + " is not a valid ingredient!");
        }
        if (args.size() >= 3 && args.get(2) instanceof Number) {
            this.processTime(((Number)args.get(2)).intValue());
        }
    }

    private static IngredientJS deserializeIngredient(JsonElement element) {
        if (element.isJsonObject()) {
            JsonObject json = element.getAsJsonObject();
            if (json.has("value")) {
                return IngredientJS.ingredientFromRecipeJson(json.get("value"));
            }
            if (json.has("values")) {
                return IngredientJS.ingredientFromRecipeJson(json.get("values"));
            }
        }
        return IngredientJS.ingredientFromRecipeJson(element);
    }

    @Override
    public void deserialize() {
        ItemStackJS result = ItemStackJS.resultFromRecipeJson(this.json.get("result"));
        if (result.isEmpty()) {
            throw new RecipeExceptionJS("Silents Mechanisms alloy smelting recipe result can't be empty!");
        }
        this.processTime = this.json.has("process_time") ? this.json.get("process_time").getAsInt() : 400;
        this.outputItems.add(result);
        for (JsonElement e : this.json.get("ingredients").getAsJsonArray()) {
            IngredientJS i = SilentsMechanmismsAlloySmeltingRecipeJS.deserializeIngredient(e);
            if (i.isEmpty()) continue;
            this.inputItems.add(i);
            if (e.isJsonObject() && e.getAsJsonObject().has("count")) {
                this.inputCount.add(e.getAsJsonObject().get("count").getAsInt());
                continue;
            }
            this.inputCount.add(1);
        }
        if (this.inputItems.isEmpty()) {
            throw new RecipeExceptionJS("Silents Mechanisms alloy smelting recipe ingredient " + this.json.get("ingredient") + " is not a valid ingredient!");
        }
    }

    @Override
    public void serialize() {
        JsonArray ingredientsJson = new JsonArray();
        for (int i = 0; i < this.inputItems.size(); ++i) {
            JsonObject ingredientJson = new JsonObject();
            JsonArray valuesJson = new JsonArray();
            if (this.inputItems.get(i) instanceof MatchAnyIngredientJS) {
                for (IngredientJS in : ((MatchAnyIngredientJS)this.inputItems.get((int)i)).ingredients) {
                    valuesJson.add(in.toJson());
                }
            } else {
                valuesJson.add(((IngredientJS)this.inputItems.get(i)).toJson());
            }
            ingredientJson.add("value", (JsonElement)valuesJson);
            ingredientJson.addProperty("count", (Number)this.inputCount.get(i));
            ingredientsJson.add((JsonElement)ingredientJson);
        }
        this.json.add("ingredients", (JsonElement)ingredientsJson);
        this.json.add("result", ((ItemStackJS)this.outputItems.get(0)).toResultJson());
        this.json.addProperty("process_time", (Number)this.processTime);
    }

    public SilentsMechanmismsAlloySmeltingRecipeJS processTime(int t) {
        this.processTime = Math.max(0, t);
        return this;
    }
}

