/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.script;

import dev.latvian.kubejs.script.BabelExecutor;
import dev.latvian.kubejs.script.ScriptFileInfo;
import dev.latvian.kubejs.script.ScriptPack;
import dev.latvian.kubejs.script.ScriptSource;
import java.io.Reader;
import javax.annotation.Nullable;
import javax.script.Bindings;

public class ScriptFile
implements Comparable<ScriptFile> {
    public final ScriptPack pack;
    public final ScriptFileInfo info;
    public final ScriptSource source;
    private Throwable error;

    public ScriptFile(ScriptPack p, ScriptFileInfo i, ScriptSource s) {
        this.pack = p;
        this.info = i;
        this.source = s;
    }

    @Nullable
    public Throwable getError() {
        return this.error;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean load(Bindings bindings) {
        this.error = null;
        try (Reader reader = this.source.createReader(this.info);){
            this.pack.engine.eval(BabelExecutor.process(reader), bindings);
            boolean bl = true;
            return bl;
        }
        catch (Throwable ex) {
            this.error = ex;
            return false;
        }
    }

    @Override
    public int compareTo(ScriptFile o) {
        return Integer.compare(o.info.getPriority(), this.info.getPriority());
    }
}

