/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.script;

import dev.latvian.kubejs.script.ScriptPackInfo;
import dev.latvian.kubejs.script.ScriptSource;
import java.io.BufferedReader;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;

public class ScriptFileInfo {
    public final ScriptPackInfo pack;
    public final String file;
    public final ResourceLocation location;
    private final Map<String, String> properties;
    private int priority;
    private Dist side;

    public ScriptFileInfo(ScriptPackInfo p, String f) {
        this.pack = p;
        this.file = f;
        this.location = new ResourceLocation(this.pack.namespace, this.pack.pathStart + this.file);
        this.properties = new HashMap<String, String>();
        this.priority = 0;
        this.side = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public Throwable preload(ScriptSource source) {
        this.properties.clear();
        try (BufferedReader reader = new BufferedReader(source.createReader(this));){
            String line;
            while ((line = reader.readLine()) != null && (line = line.trim()).startsWith("//")) {
                String[] s = line.substring(2).split(":", 2);
                if (s.length != 2) continue;
                this.properties.put(s[0].trim().toLowerCase(), s[1].trim());
            }
            this.priority = Integer.parseInt(this.getProperty("priority", "0"));
            switch (this.getProperty("side", "common").toLowerCase()) {
                case "client": {
                    this.side = Dist.CLIENT;
                    break;
                }
                case "server": {
                    this.side = Dist.DEDICATED_SERVER;
                    break;
                }
                default: {
                    this.side = null;
                }
            }
            String string = null;
            return string;
        }
        catch (Throwable ex) {
            return ex;
        }
    }

    public String getProperty(String s, String def) {
        return this.properties.getOrDefault(s, def);
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean shouldLoad(Dist dist) {
        return this.side == null || this.side == dist;
    }
}

