/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.script;

import dev.latvian.kubejs.bindings.DefaultBindings;
import dev.latvian.kubejs.event.EventJS;
import dev.latvian.kubejs.event.EventsJS;
import dev.latvian.kubejs.script.BindingsEvent;
import dev.latvian.kubejs.script.ScriptFile;
import dev.latvian.kubejs.script.ScriptPack;
import dev.latvian.kubejs.script.ScriptType;
import dev.latvian.kubejs.script.ScriptsLoadedEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import jdk.nashorn.api.scripting.NashornScriptEngineFactory;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ScriptManager {
    private static final String[] BLOCKED_FUNCTIONS = new String[]{"print", "load", "loadWithNewGlobal", "exit", "quit"};
    public final ScriptType type;
    public final EventsJS events;
    public final Map<String, ScriptPack> packs;
    public final List<String> errors;
    public ScriptFile currentFile;
    public Map<String, Object> bindings;
    public Map<String, Object> constants;

    public ScriptManager(ScriptType t) {
        this.type = t;
        this.events = new EventsJS(this);
        this.packs = new LinkedHashMap<String, ScriptPack>();
        this.errors = new ArrayList<String>();
    }

    public void unload() {
        this.events.clear();
        this.packs.clear();
    }

    public void load() {
        this.errors.clear();
        this.bindings = new HashMap<String, Object>();
        this.constants = new HashMap<String, Object>();
        BindingsEvent event = new BindingsEvent(this.type, this.bindings, this.constants);
        MinecraftForge.EVENT_BUS.post((Event)event);
        DefaultBindings.init(this, event);
        SimpleBindings b = new SimpleBindings();
        b.putAll((Map<? extends String, ? extends Object>)this.constants);
        b.putAll((Map<? extends String, ? extends Object>)this.bindings);
        int i = 0;
        int t = 0;
        for (ScriptPack pack : this.packs.values()) {
            pack.engine = new NashornScriptEngineFactory().getScriptEngine(s -> false);
            ScriptContext context = pack.engine.getContext();
            for (String s2 : BLOCKED_FUNCTIONS) {
                context.removeAttribute(s2, context.getAttributesScope(s2));
            }
            for (ScriptFile file : pack.scripts) {
                ++t;
                this.currentFile = file;
                if (file.load(b)) {
                    ++i;
                    this.type.console.info("Loaded script " + file.info.location);
                    continue;
                }
                if (file.getError() == null) continue;
                this.type.console.error("Error loading KubeJS script " + file.info.location + ": " + file.getError().toString().replace("javax.script.ScriptException: ", ""));
                if (!(file.getError() instanceof ScriptException)) {
                    file.getError().printStackTrace();
                }
                this.errors.add(file.info.location + ": " + file.getError().toString().replace("javax.script.ScriptException: ", ""));
            }
        }
        this.currentFile = null;
        if (i == t) {
            this.type.console.info("Loaded " + i + "/" + t + " KubeJS " + this.type.name + " scripts");
        } else {
            this.type.console.error("Loaded " + i + "/" + t + " KubeJS " + this.type.name + " scripts");
        }
        this.events.postToHandlers("loaded", this.events.handlers("loaded"), new EventJS());
        MinecraftForge.EVENT_BUS.post((Event)new ScriptsLoadedEvent());
    }
}

