/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.script;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;

public class ScriptModData {
    private static ScriptModData instance;
    private final String type;
    private final String mcVersion;
    private final HashSet<String> list;

    public static ScriptModData getInstance() {
        if (instance == null) {
            instance = new ScriptModData("forge", "1.14.4", ModList.get().getMods());
        }
        return instance;
    }

    public ScriptModData(String t, String mc, List<net.minecraftforge.fml.loading.moddiscovery.ModInfo> modList) {
        this.type = t;
        this.mcVersion = mc;
        this.list = new HashSet(modList.size());
        for (net.minecraftforge.fml.loading.moddiscovery.ModInfo info : modList) {
            this.list.add(info.getModId());
        }
    }

    public String getType() {
        return this.type;
    }

    public String getMcVersion() {
        return this.mcVersion;
    }

    public Set<String> getList() {
        return this.list;
    }

    public String getModVersion() {
        return ((ModContainer)ModList.get().getModContainerById("kubejs").get()).getModInfo().getVersion().toString();
    }

    public boolean isLoaded(String modId) {
        return this.list.contains(modId);
    }

    public ModInfo getInfo(String modID) {
        ModInfo info = new ModInfo(modID);
        Optional modContainer = ModList.get().getModContainerById(modID);
        if (modContainer.isPresent()) {
            IModInfo i = ((ModContainer)modContainer.get()).getModInfo();
            info.name = i.getDisplayName();
            info.version = i.getVersion().toString();
        }
        return info;
    }

    public static class ModInfo {
        private final String id;
        private String name;
        private String version;

        public ModInfo(String i) {
            this.name = this.id = i;
            this.version = "0.0.0";
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

