/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.script.data;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.kubejs.KubeJSObjects;
import dev.latvian.kubejs.block.BlockBuilder;
import dev.latvian.kubejs.fluid.FluidBuilder;
import dev.latvian.kubejs.item.ItemBuilder;
import dev.latvian.kubejs.script.ScriptType;
import dev.latvian.kubejs.util.BuilderBase;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackFileNotFoundException;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class KubeJSResourcePack
implements IResourcePack {
    private final File folder;
    private final ResourcePackType packType;

    public KubeJSResourcePack(File f, ResourcePackType t) {
        this.folder = f;
        this.packType = t;
    }

    private static String getFullPath(ResourcePackType type, ResourceLocation location) {
        return String.format("%s/%s/%s", type.func_198956_a(), location.func_110624_b(), location.func_110623_a());
    }

    @OnlyIn(value=Dist.CLIENT)
    public InputStream func_195763_b(String fileName) throws IOException {
        if (fileName.equals("pack.png")) {
            return KubeJSResourcePack.class.getResourceAsStream("/kubejs_logo.png");
        }
        throw new ResourcePackFileNotFoundException(this.folder, fileName);
    }

    public InputStream func_195761_a(ResourcePackType type, ResourceLocation location) throws IOException {
        String resourcePath = KubeJSResourcePack.getFullPath(type, location);
        if (type != this.packType) {
            throw new IllegalStateException(this.packType.func_198956_a() + " KubeJS pack can't load " + resourcePath + "!");
        }
        File file = new File(this.folder, resourcePath);
        if (file.exists()) {
            return new BufferedInputStream(new FileInputStream(file));
        }
        if (location.func_110623_a().endsWith(".json")) {
            JsonObject json = new JsonObject();
            String p = location.func_110623_a().substring(0, location.func_110623_a().length() - 5);
            if (this.packType == ResourcePackType.CLIENT_RESOURCES ? this.generateClientJsonFile(location.func_110624_b(), p, json, true) : this.generateServerJsonFile(location.func_110624_b(), p, json, true)) {
                return new ByteArrayInputStream(json.toString().getBytes(StandardCharsets.UTF_8));
            }
        }
        throw new ResourcePackFileNotFoundException(this.folder, resourcePath);
    }

    public boolean func_195764_b(ResourcePackType type, ResourceLocation location) {
        if (location.func_110623_a().endsWith(".json")) {
            String p = location.func_110623_a().substring(0, location.func_110623_a().length() - 5);
            if (this.packType == ResourcePackType.CLIENT_RESOURCES ? this.generateClientJsonFile(location.func_110624_b(), p, new JsonObject(), false) : this.generateServerJsonFile(location.func_110624_b(), p, new JsonObject(), false)) {
                return true;
            }
        }
        return type == this.packType && new File(this.folder, KubeJSResourcePack.getFullPath(type, location)).exists();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean generateClientJsonFile(String namespace, String path, JsonObject json, boolean real) {
        if (namespace.equals("kubejs") && path.equals("lang/en_us")) {
            if (!real) return true;
            for (BuilderBase builderBase : KubeJSObjects.ALL) {
                if (builderBase.displayName.isEmpty()) continue;
                json.addProperty(builderBase.translationKey, builderBase.displayName);
            }
            for (FluidBuilder fluidBuilder : KubeJSObjects.FLUIDS.values()) {
                if (fluidBuilder.displayName.isEmpty()) continue;
                json.addProperty(fluidBuilder.bucketItem.func_77658_a(), fluidBuilder.displayName + " Bucket");
            }
            return true;
        }
        if (path.startsWith("models/item/")) {
            ResourceLocation id = new ResourceLocation(namespace, path.substring(12));
            ItemBuilder itemBuilder = KubeJSObjects.ITEMS.get(id);
            if (itemBuilder == null) {
                BlockBuilder blockBuilder = KubeJSObjects.BLOCKS.get(id);
                if (blockBuilder == null) {
                    FluidBuilder fluidBuilder;
                    if (!path.endsWith("_bucket") || (fluidBuilder = KubeJSObjects.FLUIDS.get(new ResourceLocation(namespace, path.substring(12, path.length() - 7)))) == null) return false;
                    json.addProperty("parent", "kubejs:item/generated_bucket");
                    return true;
                }
                if (blockBuilder.itemBuilder == null) return false;
                if (!real) return true;
                json.addProperty("parent", blockBuilder.itemBuilder.parentModel);
                return true;
            }
            if (!real) return true;
            json.addProperty("parent", itemBuilder.parentModel);
            if (!itemBuilder.parentModel.equals("item/generated")) return true;
            JsonObject textures = new JsonObject();
            textures.addProperty("layer0", itemBuilder.texture);
            json.add("textures", (JsonElement)textures);
            return true;
        }
        if (path.startsWith("models/block/")) {
            BlockBuilder builder = KubeJSObjects.BLOCKS.get(new ResourceLocation(namespace, path.substring(13)));
            if (builder != null) {
                if (!real) return true;
                String string = builder.textures.get("particle").getAsString();
                if (this.areAllTexturesEqual(builder.textures, string)) {
                    json.addProperty("parent", "block/cube_all");
                    JsonObject textures = new JsonObject();
                    textures.addProperty("all", string);
                    json.add("textures", (JsonElement)textures);
                } else {
                    json.addProperty("parent", "block/cube");
                    json.add("textures", (JsonElement)builder.textures);
                }
                if (builder.color.isEmpty()) return true;
                JsonObject cube = new JsonObject();
                JsonArray from = new JsonArray();
                from.add((Number)0);
                from.add((Number)0);
                from.add((Number)0);
                cube.add("from", (JsonElement)from);
                JsonArray to = new JsonArray();
                to.add((Number)16);
                to.add((Number)16);
                to.add((Number)16);
                cube.add("to", (JsonElement)to);
                JsonObject faces = new JsonObject();
                for (Direction direction : Direction.values()) {
                    JsonObject f = new JsonObject();
                    f.addProperty("texture", "#" + direction.func_176610_l());
                    f.addProperty("cullface", direction.func_176610_l());
                    f.addProperty("tintindex", (Number)0);
                    faces.add(direction.func_176610_l(), (JsonElement)f);
                }
                cube.add("faces", (JsonElement)faces);
                JsonArray elements = new JsonArray();
                elements.add((JsonElement)cube);
                json.add("elements", (JsonElement)elements);
                return true;
            }
            FluidBuilder fluidBuilder = KubeJSObjects.FLUIDS.get(new ResourceLocation(namespace, path.substring(13)));
            if (fluidBuilder == null) return false;
            JsonObject textures = new JsonObject();
            textures.addProperty("particle", fluidBuilder.stillTexture.toString());
            json.add("textures", (JsonElement)textures);
            return true;
        }
        if (!path.startsWith("blockstates/")) return false;
        ResourceLocation id = new ResourceLocation(namespace, path.substring(12));
        BlockBuilder blockBuilder = KubeJSObjects.BLOCKS.get(id);
        if (blockBuilder != null) {
            if (!real) return true;
            JsonObject variants = new JsonObject();
            JsonObject model = new JsonObject();
            model.addProperty("model", blockBuilder.model);
            variants.add("", (JsonElement)model);
            json.add("variants", (JsonElement)variants);
            return true;
        }
        FluidBuilder fluidBuilder = KubeJSObjects.FLUIDS.get(id);
        if (fluidBuilder == null) return false;
        JsonObject variants = new JsonObject();
        JsonObject model = new JsonObject();
        model.addProperty("model", namespace + ":block/" + fluidBuilder.id.func_110623_a());
        variants.add("", (JsonElement)model);
        json.add("variants", (JsonElement)variants);
        return true;
    }

    private boolean areAllTexturesEqual(JsonObject tex, String t) {
        for (Direction direction : Direction.values()) {
            if (tex.get(direction.func_176610_l()).getAsString().equals(t)) continue;
            return false;
        }
        return true;
    }

    private boolean generateServerJsonFile(String namespace, String path, JsonObject json, boolean real) {
        String blockId;
        BlockBuilder builder;
        if (path.startsWith("loot_tables/blocks/") && (builder = KubeJSObjects.BLOCKS.get(new ResourceLocation(namespace, blockId = path.substring(19)))) != null) {
            if (real) {
                json.addProperty("type", "minecraft:block");
                JsonArray pools = new JsonArray();
                JsonObject pool = new JsonObject();
                pool.addProperty("rolls", (Number)1);
                JsonArray entries = new JsonArray();
                JsonObject entry = new JsonObject();
                entry.addProperty("type", "minecraft:item");
                entry.addProperty("name", builder.id.toString());
                entries.add((JsonElement)entry);
                pool.add("entries", (JsonElement)entries);
                JsonArray conditions = new JsonArray();
                JsonObject condition = new JsonObject();
                condition.addProperty("condition", "minecraft:survives_explosion");
                conditions.add((JsonElement)condition);
                pool.add("conditions", (JsonElement)conditions);
                pools.add((JsonElement)pool);
                json.add("pools", (JsonElement)pools);
            }
            return true;
        }
        return false;
    }

    public Collection<ResourceLocation> func_225637_a_(ResourcePackType type, String namespace, String path, int maxDepth, Predicate<String> filter) {
        if (type != this.packType) {
            return Collections.emptySet();
        }
        File file1 = new File(this.folder, type.func_198956_a());
        ArrayList list = Lists.newArrayList();
        if (type == ResourcePackType.CLIENT_RESOURCES) {
            if (path.equals("lang")) {
                list.add(new ResourceLocation("kubejs", "lang/en_us.json"));
            }
        } else if (path.equals("loot_tables")) {
            for (ResourceLocation id : KubeJSObjects.BLOCKS.keySet()) {
                list.add(new ResourceLocation(id.func_110624_b(), "loot_tables/blocks/" + id.func_110623_a() + ".json"));
            }
        }
        this.findResources0(new File(new File(file1, namespace), path), maxDepth, namespace, list, path.endsWith("/") ? path : path + "/", filter);
        return list;
    }

    private void findResources0(File file, int maxDepth, String namespace, List<ResourceLocation> list, String path, Predicate<String> filter) {
        File[] files = file.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        for (File f : files) {
            if (f.isDirectory()) {
                if (maxDepth <= 0) continue;
                this.findResources0(f, maxDepth - 1, namespace, list, path + f.getName() + "/", filter);
                continue;
            }
            if (f.getName().endsWith(".mcmeta") || !filter.test(f.getName())) continue;
            try {
                list.add(new ResourceLocation(namespace, path + f.getName()));
            }
            catch (ResourceLocationException ex) {
                (this.packType == ResourcePackType.CLIENT_RESOURCES ? ScriptType.CLIENT : ScriptType.SERVER).console.error(ex.getMessage());
            }
        }
    }

    public Set<String> func_195759_a(ResourcePackType type) {
        File[] list;
        if (type != this.packType) {
            return Collections.emptySet();
        }
        HashSet<String> namespaces = new HashSet<String>();
        namespaces.add("kubejs");
        for (BuilderBase builder : KubeJSObjects.ALL) {
            namespaces.add(builder.id.func_110624_b());
        }
        File file = new File(this.folder, type.func_198956_a());
        if (file.exists() && file.isDirectory() && (list = file.listFiles()) != null && list.length > 0) {
            for (File f : list) {
                if (!f.isDirectory()) continue;
                namespaces.add(f.getName().toLowerCase());
            }
        }
        return namespaces;
    }

    @Nullable
    public <T> T func_195760_a(IMetadataSectionSerializer<T> serializer) {
        return null;
    }

    public String func_195762_a() {
        return "KubeJS Resource Pack";
    }

    public void close() {
    }
}

