/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.script.data;

import com.google.common.collect.Lists;
import dev.latvian.kubejs.script.ScriptType;
import dev.latvian.kubejs.server.ServerSettings;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.packs.DelegatableResourcePack;

public class VirtualKubeJSDataPack
extends DelegatableResourcePack {
    public final boolean first;
    private final Map<ResourceLocation, String> locationToData;
    private final Map<String, String> pathToData;
    private final Set<String> namespaces;

    public VirtualKubeJSDataPack(boolean f) {
        super(new File("dummy"));
        this.first = f;
        this.locationToData = new HashMap<ResourceLocation, String>();
        this.pathToData = new HashMap<String, String>();
        this.namespaces = new HashSet<String>();
    }

    public void addData(ResourceLocation id, String data) {
        this.locationToData.put(id, data);
        this.pathToData.put("data/" + id.func_110624_b() + "/" + id.func_110623_a(), data);
        this.namespaces.add(id.func_110624_b());
    }

    public void resetData() {
        this.locationToData.clear();
        this.pathToData.clear();
        this.namespaces.clear();
    }

    public InputStream func_195766_a(String path) throws IOException {
        String s = this.pathToData.get(path);
        if (s != null) {
            if (ServerSettings.instance.dataPackOutput) {
                ScriptType.SERVER.console.info("Served virtual file '" + path + "': " + s);
            }
            return new ByteArrayInputStream(s.getBytes(StandardCharsets.UTF_8));
        }
        throw new FileNotFoundException(path);
    }

    public InputStream func_195761_a(ResourcePackType type, ResourceLocation location) throws IOException {
        String s = this.locationToData.get(location);
        if (s != null) {
            if (ServerSettings.instance.dataPackOutput) {
                ScriptType.SERVER.console.info("Served virtual file '" + location + "': " + s);
            }
            return new ByteArrayInputStream(s.getBytes(StandardCharsets.UTF_8));
        }
        throw new FileNotFoundException(location.toString());
    }

    public boolean func_195768_c(String path) {
        return this.pathToData.containsKey(path);
    }

    public boolean func_195764_b(ResourcePackType type, ResourceLocation location) {
        return type == ResourcePackType.SERVER_DATA && this.locationToData.containsKey(location);
    }

    public Collection<ResourceLocation> func_225637_a_(ResourcePackType type, String namespace, String path, int maxDepth, Predicate<String> filter) {
        ArrayList list = Lists.newArrayList();
        for (ResourceLocation key : this.locationToData.keySet()) {
            if (!namespace.equals(key.func_110624_b())) continue;
            try {
                String p;
                int i = key.func_110623_a().lastIndexOf(47);
                String string = p = i == -1 ? key.func_110623_a() : key.func_110623_a().substring(i + 1);
                if (!key.func_110623_a().startsWith(path) || !filter.test(p)) continue;
                list.add(key);
            }
            catch (Exception exception) {}
        }
        return list;
    }

    public Set<String> func_195759_a(ResourcePackType type) {
        return new HashSet<String>(this.namespaces);
    }

    @Nullable
    public <T> T func_195760_a(IMetadataSectionSerializer<T> serializer) {
        return null;
    }

    public String func_195762_a() {
        return "KubeJS Virtual Data Pack [First: " + this.first + "]";
    }

    public void close() {
    }

    public boolean hasNamespace(String key) {
        return this.namespaces.contains(key);
    }
}

