/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.server;

import com.mojang.brigadier.CommandDispatcher;
import dev.latvian.kubejs.KubeJS;
import dev.latvian.kubejs.command.CommandRegistryEventJS;
import dev.latvian.kubejs.command.KubeJSCommands;
import dev.latvian.kubejs.core.SimpleReloadableResourceManagerKJS;
import dev.latvian.kubejs.player.PlayerDataJS;
import dev.latvian.kubejs.player.ServerPlayerDataJS;
import dev.latvian.kubejs.player.SimplePlayerEventJS;
import dev.latvian.kubejs.script.ScriptType;
import dev.latvian.kubejs.script.data.KubeJSDataPackFinder;
import dev.latvian.kubejs.server.AttachServerDataEvent;
import dev.latvian.kubejs.server.CommandEventJS;
import dev.latvian.kubejs.server.ScheduledEvent;
import dev.latvian.kubejs.server.ServerEventJS;
import dev.latvian.kubejs.server.ServerJS;
import dev.latvian.kubejs.server.ServerSettings;
import dev.latvian.kubejs.world.AttachWorldDataEvent;
import dev.latvian.kubejs.world.ServerWorldJS;
import dev.latvian.kubejs.world.SimpleWorldEventJS;
import dev.latvian.kubejs.world.WorldJS;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IPackFinder;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;

public class KubeJSServerEventHandler {
    public void init() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGHEST, this::serverAboutToStartEarly);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::serverAboutToStartLate);
        MinecraftForge.EVENT_BUS.addListener(this::serverStarting);
        MinecraftForge.EVENT_BUS.addListener(this::serverStarted);
        MinecraftForge.EVENT_BUS.addListener(this::serverStopping);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::serverTick);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOW, this::command);
    }

    private void serverAboutToStartEarly(FMLServerAboutToStartEvent event) {
        if (ServerJS.instance != null) {
            this.destroyServer();
        }
        ServerJS.instance = new ServerJS(event.getServer());
        ServerSettings.instance = ServerJS.instance;
        event.getServer().func_195561_aH().func_198982_a((IPackFinder)new KubeJSDataPackFinder(KubeJS.getGameDirectory().resolve("kubejs").toFile()));
    }

    private void serverAboutToStartLate(FMLServerAboutToStartEvent event) {
        try {
            SimpleReloadableResourceManagerKJS manager = (SimpleReloadableResourceManagerKJS)event.getServer().func_195570_aG();
            IFutureReloadListener reloadListener = ServerJS.instance.createReloadListener();
            manager.getReloadListenersKJS().add(0, reloadListener);
            manager.getInitTaskQueueKJS().add(0, reloadListener);
        }
        catch (Exception ex) {
            throw new RuntimeException("KubeJS failed to register it's script loader!");
        }
    }

    private void serverStarting(FMLServerStartingEvent event) {
        KubeJSCommands.register((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
        new CommandRegistryEventJS(event.getServer().func_71264_H(), (CommandDispatcher<CommandSource>)event.getCommandDispatcher()).post(ScriptType.SERVER, "command.registry");
    }

    private void serverStarted(FMLServerStartedEvent event) {
        ServerJS.instance.overworld = new ServerWorldJS(ServerJS.instance, ServerJS.instance.minecraftServer.func_71218_a(DimensionType.field_223227_a_));
        ServerJS.instance.worldMap.put(DimensionType.field_223227_a_, ServerJS.instance.overworld);
        ServerJS.instance.worlds.add(ServerJS.instance.overworld);
        for (ServerWorld serverWorld : ServerJS.instance.minecraftServer.func_212370_w()) {
            if (serverWorld == ServerJS.instance.overworld.minecraftWorld) continue;
            ServerWorldJS w = new ServerWorldJS(ServerJS.instance, serverWorld);
            ServerJS.instance.worldMap.put(serverWorld.func_201675_m().func_186058_p(), w);
        }
        ServerJS.instance.updateWorldList();
        MinecraftForge.EVENT_BUS.post((Event)new AttachServerDataEvent(ServerJS.instance));
        new ServerEventJS().post(ScriptType.SERVER, "server.load");
        for (ServerWorldJS serverWorldJS : ServerJS.instance.worlds) {
            MinecraftForge.EVENT_BUS.post((Event)new AttachWorldDataEvent(ServerJS.instance.getOverworld()));
            new SimpleWorldEventJS(ServerJS.instance.getOverworld()).post("world.load");
        }
    }

    private void serverStopping(FMLServerStoppingEvent event) {
        this.destroyServer();
    }

    private void destroyServer() {
        for (PlayerDataJS playerDataJS : new ArrayList<ServerPlayerDataJS>(ServerJS.instance.playerMap.values())) {
            new SimplePlayerEventJS((PlayerEntity)playerDataJS.getMinecraftPlayer()).post("player.logged_out");
            ServerJS.instance.playerMap.remove(playerDataJS.getId());
        }
        ServerJS.instance.playerMap.clear();
        for (WorldJS worldJS : new ArrayList<ServerWorldJS>(ServerJS.instance.worldMap.values())) {
            new SimpleWorldEventJS(worldJS).post("world.unload");
            ServerJS.instance.worldMap.remove(worldJS.getDimension());
        }
        ServerJS.instance.updateWorldList();
        new ServerEventJS().post(ScriptType.SERVER, "server.unload");
        ServerJS.instance = null;
        ServerSettings.instance = null;
    }

    private void serverTick(TickEvent.ServerTickEvent event) {
        Object e;
        ArrayList<Object> list;
        Iterator<ScheduledEvent> eventIterator;
        long now;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        ServerJS s = ServerJS.instance;
        if (!s.scheduledEvents.isEmpty()) {
            now = System.currentTimeMillis();
            eventIterator = s.scheduledEvents.iterator();
            list = new ArrayList<Object>();
            while (eventIterator.hasNext()) {
                e = eventIterator.next();
                if (now < ((ScheduledEvent)e).getEndTime()) continue;
                list.add(e);
                eventIterator.remove();
            }
            for (ScheduledEvent scheduledEvent : list) {
                try {
                    scheduledEvent.call();
                }
                catch (Throwable ex) {
                    if (ex.getClass().getName().equals("jdk.nashorn.api.scripting.NashornException")) {
                        scheduledEvent.file.pack.manager.type.console.error("Error occurred while handling scheduled event callback in " + scheduledEvent.file.info.location + ": " + ex);
                        continue;
                    }
                    ex.printStackTrace();
                }
            }
        }
        if (!s.scheduledTickEvents.isEmpty()) {
            now = s.getOverworld().getTime();
            eventIterator = s.scheduledTickEvents.iterator();
            list = new ArrayList();
            while (eventIterator.hasNext()) {
                e = eventIterator.next();
                if (now < ((ScheduledEvent)e).getEndTime()) continue;
                list.add(e);
                eventIterator.remove();
            }
            for (ScheduledEvent scheduledEvent : list) {
                try {
                    scheduledEvent.call();
                }
                catch (Throwable ex) {
                    if (ex.getClass().getName().equals("jdk.nashorn.api.scripting.NashornException")) {
                        scheduledEvent.file.pack.manager.type.console.error("Error occurred while handling scheduled event callback in " + scheduledEvent.file.info.location + ": " + ex);
                        continue;
                    }
                    ex.printStackTrace();
                }
            }
        }
        new ServerEventJS().post(ScriptType.SERVER, "server.tick");
    }

    private void command(CommandEvent event) {
        if (new CommandEventJS(event).post(ScriptType.SERVER, "command.run")) {
            event.setCanceled(true);
        }
    }
}

