/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.server;

import dev.latvian.kubejs.KubeJS;
import dev.latvian.kubejs.core.SimpleReloadableResourceManagerKJS;
import dev.latvian.kubejs.docs.ID;
import dev.latvian.kubejs.docs.MinecraftClass;
import dev.latvian.kubejs.net.KubeJSNet;
import dev.latvian.kubejs.net.MessageSendDataFromServer;
import dev.latvian.kubejs.player.AdvancementJS;
import dev.latvian.kubejs.player.EntityArrayList;
import dev.latvian.kubejs.player.FakeServerPlayerDataJS;
import dev.latvian.kubejs.player.PlayerDataJS;
import dev.latvian.kubejs.player.PlayerJS;
import dev.latvian.kubejs.player.ServerPlayerDataJS;
import dev.latvian.kubejs.recipe.RecipeEventJS;
import dev.latvian.kubejs.recipe.RecipeTypeJS;
import dev.latvian.kubejs.recipe.RegisterRecipeHandlersEvent;
import dev.latvian.kubejs.script.ScriptFile;
import dev.latvian.kubejs.script.ScriptFileInfo;
import dev.latvian.kubejs.script.ScriptManager;
import dev.latvian.kubejs.script.ScriptPack;
import dev.latvian.kubejs.script.ScriptPackInfo;
import dev.latvian.kubejs.script.ScriptSource;
import dev.latvian.kubejs.script.ScriptType;
import dev.latvian.kubejs.script.data.DataPackEventJS;
import dev.latvian.kubejs.script.data.VirtualKubeJSDataPack;
import dev.latvian.kubejs.server.IScheduledEventCallback;
import dev.latvian.kubejs.server.ScheduledEvent;
import dev.latvian.kubejs.server.ServerSettings;
import dev.latvian.kubejs.text.Text;
import dev.latvian.kubejs.util.AttachedData;
import dev.latvian.kubejs.util.MapJS;
import dev.latvian.kubejs.util.MessageSender;
import dev.latvian.kubejs.util.UUIDUtilsJS;
import dev.latvian.kubejs.util.UtilsJS;
import dev.latvian.kubejs.util.WithAttachedData;
import dev.latvian.kubejs.world.AttachWorldDataEvent;
import dev.latvian.kubejs.world.ServerWorldJS;
import dev.latvian.kubejs.world.WorldJS;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.resources.FallbackResourceManager;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IWorld;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.network.PacketDistributor;

public class ServerJS
extends ServerSettings
implements MessageSender,
WithAttachedData {
    public static ServerJS instance;
    @MinecraftClass
    public final MinecraftServer minecraftServer;
    public final ScriptManager scriptManager;
    public final List<ScheduledEvent> scheduledEvents;
    public final List<ScheduledEvent> scheduledTickEvents;
    public final Map<DimensionType, ServerWorldJS> worldMap;
    public final Map<UUID, ServerPlayerDataJS> playerMap;
    public final Map<UUID, FakeServerPlayerDataJS> fakePlayerMap;
    public final List<ServerWorldJS> worlds;
    public ServerWorldJS overworld;
    private AttachedData data;
    private final VirtualKubeJSDataPack virtualDataPackFirst;
    private final VirtualKubeJSDataPack virtualDataPackLast;

    public ServerJS(MinecraftServer ms) {
        this.minecraftServer = ms;
        this.scriptManager = new ScriptManager(ScriptType.SERVER);
        this.scheduledEvents = new LinkedList<ScheduledEvent>();
        this.scheduledTickEvents = new LinkedList<ScheduledEvent>();
        this.worldMap = new HashMap<DimensionType, ServerWorldJS>();
        this.playerMap = new HashMap<UUID, ServerPlayerDataJS>();
        this.fakePlayerMap = new HashMap<UUID, FakeServerPlayerDataJS>();
        this.worlds = new ArrayList<ServerWorldJS>();
        this.virtualDataPackFirst = new VirtualKubeJSDataPack(true);
        this.virtualDataPackLast = new VirtualKubeJSDataPack(false);
    }

    public void updateWorldList() {
        this.worlds.clear();
        this.worlds.addAll(this.worldMap.values());
    }

    @Override
    public AttachedData getData() {
        if (this.data == null) {
            this.data = new AttachedData(this);
        }
        return this.data;
    }

    public List<ServerWorldJS> getWorlds() {
        return this.worlds;
    }

    public ServerWorldJS getOverworld() {
        return this.overworld;
    }

    public boolean isRunning() {
        return this.minecraftServer.func_71278_l();
    }

    public boolean getHardcore() {
        return this.minecraftServer.func_71199_h();
    }

    public void setHardcore(boolean hardcore) {
        this.overworld.minecraftWorld.func_72912_H().func_176119_g(hardcore);
    }

    public boolean isSinglePlayer() {
        return this.minecraftServer.func_71264_H();
    }

    public boolean isDedicated() {
        return this.minecraftServer.func_71262_S();
    }

    public String getMotd() {
        return this.minecraftServer.func_71273_Y();
    }

    public void setMotd(Object text) {
        this.minecraftServer.func_71205_p(Text.of(text).component().func_150254_d());
    }

    public void stop() {
        this.minecraftServer.close();
    }

    @Override
    public Text getName() {
        return Text.of(this.minecraftServer.func_213142_bd());
    }

    @Override
    public Text getDisplayName() {
        return Text.of(this.minecraftServer.func_195573_aM().func_197019_b());
    }

    @Override
    public void tell(Object message) {
        ITextComponent component = Text.of(message).component();
        this.minecraftServer.func_145747_a(component);
        for (ServerPlayerEntity player : this.minecraftServer.func_184103_al().func_181057_v()) {
            player.func_145747_a(component);
        }
    }

    @Override
    public void setStatusMessage(Object message) {
        ITextComponent component = Text.of(message).component();
        for (ServerPlayerEntity player : this.minecraftServer.func_184103_al().func_181057_v()) {
            player.func_146105_b(component, true);
        }
    }

    @Override
    public int runCommand(String command) {
        return this.minecraftServer.func_195571_aL().func_197059_a(this.minecraftServer.func_195573_aM(), command);
    }

    public WorldJS getWorld(DimensionType dimension) {
        if (dimension == DimensionType.field_223227_a_) {
            return this.overworld;
        }
        ServerWorldJS world = this.worldMap.get(dimension);
        if (world == null) {
            world = new ServerWorldJS(this, this.minecraftServer.func_71218_a(dimension));
            this.worldMap.put(dimension, world);
            this.updateWorldList();
            MinecraftForge.EVENT_BUS.post((Event)new AttachWorldDataEvent(world));
        }
        return world;
    }

    public WorldJS getWorld(IWorld minecraftWorld) {
        return this.getWorld(minecraftWorld.func_201675_m().func_186058_p());
    }

    @Nullable
    public PlayerJS getPlayer(UUID uuid) {
        ServerPlayerDataJS p = this.playerMap.get(uuid);
        if (p == null) {
            return null;
        }
        return p.getPlayer();
    }

    @Nullable
    public PlayerJS getPlayer(String name) {
        if ((name = name.trim().toLowerCase()).isEmpty()) {
            return null;
        }
        UUID uuid = UUIDUtilsJS.fromString(name);
        if (uuid != null) {
            return this.getPlayer(uuid);
        }
        for (PlayerDataJS playerDataJS : this.playerMap.values()) {
            if (!playerDataJS.getName().equalsIgnoreCase(name)) continue;
            return playerDataJS.getPlayer();
        }
        for (PlayerDataJS playerDataJS : this.playerMap.values()) {
            if (!playerDataJS.getName().toLowerCase().contains(name)) continue;
            return playerDataJS.getPlayer();
        }
        return null;
    }

    @Nullable
    public PlayerJS getPlayer(PlayerEntity minecraftPlayer) {
        return this.getPlayer(minecraftPlayer.func_110124_au());
    }

    public EntityArrayList getPlayers() {
        return new EntityArrayList((WorldJS)this.overworld, this.minecraftServer.func_184103_al().func_181057_v());
    }

    public EntityArrayList getEntities() {
        EntityArrayList list = new EntityArrayList((WorldJS)this.overworld, 10);
        for (ServerWorldJS world : this.worlds) {
            list.addAll(world.getEntities());
        }
        return list;
    }

    public EntityArrayList getEntities(String filter) {
        EntityArrayList list = new EntityArrayList((WorldJS)this.overworld, 10);
        for (ServerWorldJS world : this.worlds) {
            list.addAll(world.getEntities(filter));
        }
        return list;
    }

    public ScheduledEvent schedule(long timer, @Nullable Object data, IScheduledEventCallback event) {
        ScheduledEvent e = new ScheduledEvent(this, false, timer, System.currentTimeMillis() + timer, data, event);
        this.scheduledEvents.add(e);
        return e;
    }

    public ScheduledEvent schedule(long timer, IScheduledEventCallback event) {
        return this.schedule(timer, null, event);
    }

    public ScheduledEvent scheduleInTicks(long ticks, @Nullable Object data, IScheduledEventCallback event) {
        ScheduledEvent e = new ScheduledEvent(this, true, ticks, this.overworld.getTime() + ticks, data, event);
        this.scheduledEvents.add(e);
        return e;
    }

    public ScheduledEvent scheduleInTicks(long ticks, IScheduledEventCallback event) {
        return this.scheduleInTicks(ticks, null, event);
    }

    public String toString() {
        return "Server";
    }

    @Nullable
    public AdvancementJS getAdvancement(@ID String id) {
        Advancement a = this.minecraftServer.func_191949_aK().func_192778_a(UtilsJS.getMCID(id));
        return a == null ? null : new AdvancementJS(a);
    }

    public void sendDataToAll(String channel, @Nullable Object data) {
        KubeJSNet.MAIN.send(PacketDistributor.ALL.noArg(), (Object)new MessageSendDataFromServer(channel, MapJS.nbt(data)));
    }

    /*
     * WARNING - void declaration
     */
    public void reloadScripts(SimpleReloadableResourceManager resourceManager) {
        void var4_9;
        this.scriptManager.unload();
        HashMap<String, List> packs = new HashMap<String, List>();
        for (ResourceLocation resourceLocation : resourceManager.func_199003_a("kubejs", s -> s.endsWith(".js"))) {
            packs.computeIfAbsent(resourceLocation.func_110624_b(), s -> new ArrayList()).add(resourceLocation);
        }
        for (Map.Entry entry : packs.entrySet()) {
            ScriptPack pack = new ScriptPack(this.scriptManager, new ScriptPackInfo((String)entry.getKey(), "kubejs/"));
            for (ResourceLocation id : (List)entry.getValue()) {
                pack.info.scripts.add(new ScriptFileInfo(pack.info, id.func_110623_a().substring(7)));
            }
            for (ScriptFileInfo fileInfo : pack.info.scripts) {
                ScriptSource scriptSource;
                Throwable error = fileInfo.preload(scriptSource = info -> new InputStreamReader(resourceManager.func_199002_a(info.location).func_199027_b()));
                if (error == null) {
                    if (!fileInfo.shouldLoad(FMLEnvironment.dist)) continue;
                    pack.scripts.add(new ScriptFile(pack, fileInfo, scriptSource));
                    continue;
                }
                KubeJS.LOGGER.error("Failed to pre-load script file " + fileInfo.location + ": " + error);
            }
            pack.scripts.sort(null);
            this.scriptManager.packs.put(pack.info.namespace, pack);
        }
        this.virtualDataPackFirst.resetData();
        ScriptType.SERVER.console.setLineNumber(true);
        this.scriptManager.load();
        new DataPackEventJS(this.virtualDataPackFirst).post(ScriptType.SERVER, "server.datapack.first");
        new DataPackEventJS(this.virtualDataPackLast).post(ScriptType.SERVER, "server.datapack.last");
        resourceManager.func_199021_a((IResourcePack)this.virtualDataPackFirst);
        resourceManager.func_199021_a((IResourcePack)this.virtualDataPackLast);
        Map<String, FallbackResourceManager> namespaceResourceManagers = ((SimpleReloadableResourceManagerKJS)resourceManager).getNamespaceResourceManagersKJS();
        for (FallbackResourceManager manager : namespaceResourceManagers.values()) {
            if (!manager.field_199023_a.remove((Object)this.virtualDataPackLast)) continue;
            manager.field_199023_a.add(0, this.virtualDataPackLast);
        }
        ScriptType.SERVER.console.setLineNumber(false);
        ScriptType.SERVER.console.info("Scripts loaded");
        boolean bl = false;
        while (var4_9 < this.scriptManager.errors.size()) {
            this.minecraftServer.func_184103_al().func_148539_a(new StringTextComponent("#" + (int)(var4_9 + true) + ": ").func_211708_a(TextFormatting.DARK_RED).func_150257_a(new StringTextComponent(this.scriptManager.errors.get((int)var4_9)).func_211708_a(TextFormatting.RED)));
            ++var4_9;
        }
        HashMap<ResourceLocation, RecipeTypeJS> hashMap = new HashMap<ResourceLocation, RecipeTypeJS>();
        MinecraftForge.EVENT_BUS.post((Event)new RegisterRecipeHandlersEvent(hashMap));
        RecipeEventJS.instance = new RecipeEventJS(hashMap);
    }

    public IFutureReloadListener createReloadListener() {
        return (stage, resourceManager, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor) -> {
            if (!(resourceManager instanceof SimpleReloadableResourceManager)) {
                throw new RuntimeException("Resource manager is not SimpleReloadableResourceManager, KubeJS will not work! Unsupported resource manager class: " + resourceManager.getClass());
            }
            this.reloadScripts((SimpleReloadableResourceManager)resourceManager);
            return ((CompletableFuture)CompletableFuture.supplyAsync(Object::new, backgroundExecutor).thenCompose(arg_0 -> ((IFutureReloadListener.IStage)stage).func_216872_a(arg_0))).thenAcceptAsync(o -> {}, gameExecutor);
        };
    }
}

