/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.server;

import dev.latvian.kubejs.core.TagBuilderKJS;
import dev.latvian.kubejs.docs.ID;
import dev.latvian.kubejs.event.EventJS;
import dev.latvian.kubejs.script.ScriptType;
import dev.latvian.kubejs.util.ListJS;
import dev.latvian.kubejs.util.UtilsJS;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;

public class TagEventJS<T>
extends EventJS {
    private final String type;
    private final Map<ResourceLocation, Tag.Builder<T>> map;
    private final Function<ResourceLocation, Optional<T>> getter;
    private Map<ResourceLocation, TagWrapper<T>> tags;
    private int addedCount;
    private int removedCount;

    public TagEventJS(String t, Map<ResourceLocation, Tag.Builder<T>> m, Function<ResourceLocation, Optional<T>> g) {
        this.type = t;
        this.map = m;
        this.getter = g;
    }

    public String getType() {
        return this.type;
    }

    public void post(String event) {
        this.tags = new HashMap<ResourceLocation, TagWrapper<T>>();
        for (Map.Entry<ResourceLocation, Tag.Builder<T>> entry : this.map.entrySet()) {
            TagWrapper w = new TagWrapper(this, entry.getKey(), entry.getValue());
            this.tags.put(entry.getKey(), w);
            ScriptType.SERVER.console.debug(this.type + "/#" + entry.getKey() + "; " + w.entries.size());
        }
        ScriptType.SERVER.console.setLineNumber(true);
        this.post(ScriptType.SERVER, event);
        this.post(ScriptType.SERVER, "server.datapack.tags." + this.type);
        ScriptType.SERVER.console.setLineNumber(false);
        ScriptType.SERVER.console.info("[" + this.type + "] Found " + this.tags.size() + " tags, added " + this.addedCount + ", removed " + this.removedCount);
    }

    public TagWrapper<T> get(@ID String tag) {
        ResourceLocation id = UtilsJS.getMCID(tag);
        TagWrapper<T> t = this.tags.get(id);
        if (t == null) {
            t = new TagWrapper(this, id, new Tag.Builder());
            this.tags.put(id, t);
            this.map.put(id, ((TagWrapper)t).tag);
        }
        return t;
    }

    public static class TagWrapper<T> {
        private final TagEventJS<T> event;
        private final ResourceLocation id;
        private final Tag.Builder<T> tag;
        private final Set<Tag.ITagEntry<T>> entries;

        private TagWrapper(TagEventJS<T> e, ResourceLocation i, Tag.Builder<T> t) {
            this.event = e;
            this.id = i;
            this.tag = t;
            this.entries = ((TagBuilderKJS)this.tag).getEntriesKJS();
        }

        public TagWrapper<T> add(Object ids) {
            for (Object o : ListJS.orSelf(ids)) {
                String s = String.valueOf(o);
                if (s.startsWith("#")) {
                    TagWrapper<T> w = this.event.get(s.substring(1));
                    this.entries.add((Tag.ITagEntry<T>)new Tag.TagEntry(w.id));
                    TagEventJS<T> tagEventJS = this.event;
                    ((TagEventJS)tagEventJS).addedCount = ((TagEventJS)tagEventJS).addedCount + w.entries.size();
                    ScriptType.SERVER.console.info("+ " + ((TagEventJS)this.event).type + ":" + this.id + " // " + w.id);
                    continue;
                }
                ResourceLocation sid = new ResourceLocation(s);
                Optional v = (Optional)((TagEventJS)this.event).getter.apply(sid);
                if (v.isPresent()) {
                    this.entries.add((Tag.ITagEntry<T>)new Tag.ListEntry(Collections.singleton(v.get())));
                    ((TagEventJS)this.event).addedCount++;
                    ScriptType.SERVER.console.info("+ " + ((TagEventJS)this.event).type + ":" + this.id + " // " + s + " [" + v.get().getClass().getName() + "]");
                    continue;
                }
                ScriptType.SERVER.console.warn("+ " + ((TagEventJS)this.event).type + ":" + this.id + " // " + s + " [Not found!]");
            }
            return this;
        }

        public TagWrapper<T> remove(Object ids) {
            for (Object o : ListJS.orSelf(ids)) {
                String s = String.valueOf(o);
                if (s.startsWith("#")) {
                    TagWrapper<T> w = this.event.get(s.substring(1));
                    this.entries.remove(new Tag.TagEntry(w.id));
                    TagEventJS<T> tagEventJS = this.event;
                    ((TagEventJS)tagEventJS).removedCount = ((TagEventJS)tagEventJS).removedCount + w.entries.size();
                    ScriptType.SERVER.console.info("- " + ((TagEventJS)this.event).type + ":" + this.id + " // " + w.id);
                    continue;
                }
                ResourceLocation sid = new ResourceLocation(s);
                Optional v = (Optional)((TagEventJS)this.event).getter.apply(sid);
                if (v.isPresent()) {
                    this.entries.remove(new Tag.ListEntry(Collections.singleton(v.get())));
                    ((TagEventJS)this.event).removedCount++;
                    ScriptType.SERVER.console.info("- " + ((TagEventJS)this.event).type + ":" + this.id + " // " + s + " [" + v.get().getClass().getName() + "]");
                    continue;
                }
                ScriptType.SERVER.console.warn("- " + ((TagEventJS)this.event).type + ":" + this.id + " // " + s + " [Not found!]");
            }
            return this;
        }

        public TagWrapper<T> removeAll() {
            ScriptType.SERVER.console.info("- " + ((TagEventJS)this.event).type + ":" + this.id + " // (all)");
            TagEventJS<T> tagEventJS = this.event;
            ((TagEventJS)tagEventJS).removedCount = ((TagEventJS)tagEventJS).removedCount + this.entries.size();
            this.entries.clear();
            return this;
        }
    }
}

