/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.text;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.kubejs.text.TextColor;
import dev.latvian.kubejs.text.TextString;
import dev.latvian.kubejs.text.TextTranslate;
import dev.latvian.kubejs.util.JSObjectType;
import dev.latvian.kubejs.util.JsonSerializable;
import dev.latvian.kubejs.util.ListJS;
import dev.latvian.kubejs.util.MapJS;
import dev.latvian.kubejs.util.UtilsJS;
import dev.latvian.kubejs.util.WrappedJS;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public abstract class Text
implements Iterable<Text>,
Comparable<Text>,
JsonSerializable,
WrappedJS {
    private TextColor color;
    private Boolean bold;
    private Boolean italic;
    private Boolean underlined;
    private Boolean strikethrough;
    private Boolean obfuscated;
    private String insertion;
    private String click;
    private Text hover;
    private List<Text> siblings;

    public static Text of(@Nullable Object o) {
        return Text.ofWrapped(UtilsJS.wrap(o, JSObjectType.ANY));
    }

    private static Text ofWrapped(@Nullable Object o) {
        MapJS map;
        if (o == null) {
            return new TextString("null");
        }
        if (o instanceof CharSequence || o instanceof Number || o instanceof Character) {
            return new TextString(o.toString());
        }
        if (o instanceof Enum) {
            return new TextString(((Enum)o).name());
        }
        if (o instanceof Text) {
            return (Text)o;
        }
        if (o instanceof ListJS) {
            TextString text = new TextString("");
            for (Object e1 : (ListJS)o) {
                text.append(Text.ofWrapped(e1));
            }
            return text;
        }
        if (o instanceof MapJS && ((map = (MapJS)o).containsKey("text") || map.containsKey("translate"))) {
            Text text;
            if (map.containsKey("text")) {
                text = new TextString(map.get("text").toString());
            } else {
                Object[] with;
                if (map.containsKey("with")) {
                    ListJS a = map.getOrNewList("with");
                    with = new Object[a.size()];
                    int i = 0;
                    for (Object e1 : a) {
                        with[i] = e1;
                        if (with[i] instanceof MapJS || with[i] instanceof ListJS) {
                            with[i] = Text.ofWrapped(e1);
                        }
                        ++i;
                    }
                } else {
                    with = new Object[]{};
                }
                text = new TextTranslate(map.get("translate").toString(), with);
            }
            if (map.containsKey("color")) {
                text.color = TextColor.MAP.get(map.get("color").toString());
            }
            text.bold = map.containsKey("bold") ? (Boolean)map.get("bold") : null;
            text.italic = map.containsKey("italic") ? (Boolean)map.get("italic") : null;
            text.underlined = map.containsKey("underlined") ? (Boolean)map.get("underlined") : null;
            text.strikethrough = map.containsKey("strikethrough") ? (Boolean)map.get("strikethrough") : null;
            text.obfuscated = map.containsKey("obfuscated") ? (Boolean)map.get("obfuscated") : null;
            text.insertion = map.containsKey("insertion") ? map.get("insertion").toString() : null;
            text.click = map.containsKey("click") ? map.get("click").toString() : null;
            text.hover = map.containsKey("hover") ? Text.ofWrapped(map.get("hover")) : null;
            text.siblings = null;
            if (map.containsKey("extra")) {
                for (Object e : map.getOrNewList("extra")) {
                    text.append(Text.ofWrapped(e));
                }
            }
            return text;
        }
        return new TextString(o.toString());
    }

    public static Text join(Text separator, Iterable<Text> texts) {
        TextString text = new TextString("");
        boolean first = true;
        for (Text t : texts) {
            if (first) {
                first = false;
            } else {
                text.append(separator);
            }
            text.append(t);
        }
        return text;
    }

    public static Text read(PacketBuffer buffer) {
        return Text.of(buffer.func_179258_d());
    }

    public abstract ITextComponent rawComponent();

    public abstract Text rawCopy();

    @Override
    public abstract JsonElement toJson();

    public final ITextComponent component() {
        ITextComponent component = this.rawComponent();
        if (this.color != null) {
            component.func_150256_b().func_150238_a(this.color.textFormatting);
        }
        component.func_150256_b().func_150227_a(this.bold);
        component.func_150256_b().func_150217_b(this.italic);
        component.func_150256_b().func_150228_d(this.underlined);
        component.func_150256_b().func_150225_c(this.strikethrough);
        component.func_150256_b().func_150237_e(this.obfuscated);
        component.func_150256_b().func_179989_a(this.insertion);
        if (this.click != null) {
            if (this.click.startsWith("command:")) {
                component.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, this.click.substring(8)));
            } else if (this.click.startsWith("suggest_command:")) {
                component.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, this.click.substring(16)));
            } else if (this.click.startsWith("copy:")) {
                component.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, this.click.substring(5)));
            } else {
                component.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, this.click));
            }
        }
        if (this.hover != null) {
            component.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, this.hover.component()));
        }
        for (Text text : this.getSiblings()) {
            component.func_150257_a(text.component());
        }
        return component;
    }

    public final String getUnformattedString() {
        return this.component().getString();
    }

    public final String getFormattedString() {
        return this.component().func_150254_d();
    }

    public final Text copy() {
        Text t = this.rawCopy();
        t.color = this.color;
        t.bold = this.bold;
        t.italic = this.italic;
        t.underlined = this.underlined;
        t.strikethrough = this.strikethrough;
        t.obfuscated = this.obfuscated;
        t.insertion = this.insertion;
        t.click = this.click;
        t.hover = this.hover == null ? null : this.hover.copy();
        for (Text child : this.getSiblings()) {
            t.append(child.copy());
        }
        return t;
    }

    public final JsonObject getPropertiesAsJson() {
        JsonObject json = new JsonObject();
        if (this.color != null) {
            json.addProperty("color", this.color.textFormatting.func_96297_d());
        }
        if (this.bold != null) {
            json.addProperty("bold", this.bold);
        }
        if (this.italic != null) {
            json.addProperty("italic", this.italic);
        }
        if (this.underlined != null) {
            json.addProperty("underlined", this.underlined);
        }
        if (this.strikethrough != null) {
            json.addProperty("strikethrough", this.strikethrough);
        }
        if (this.obfuscated != null) {
            json.addProperty("obfuscated", this.obfuscated);
        }
        if (this.insertion != null) {
            json.addProperty("insertion", this.insertion);
        }
        if (this.click != null) {
            json.addProperty("click", this.click);
        }
        if (this.hover != null) {
            json.add("hover", this.hover.toJson());
        }
        if (!this.getSiblings().isEmpty()) {
            JsonArray array = new JsonArray();
            for (Text child : this.getSiblings()) {
                array.add(child.toJson());
            }
            json.add("extra", (JsonElement)array);
        }
        return json;
    }

    @Override
    public final Iterator<Text> iterator() {
        if (this.getSiblings().isEmpty()) {
            return Collections.singleton(this).iterator();
        }
        ArrayList<Text> list = new ArrayList<Text>();
        list.add(this);
        for (Text child : this.getSiblings()) {
            for (Text part : child) {
                list.add(part);
            }
        }
        return list.iterator();
    }

    public final Text color(TextColor value) {
        this.color = value;
        return this;
    }

    public final Text black() {
        return this.color(TextColor.BLACK);
    }

    public final Text darkBlue() {
        return this.color(TextColor.DARK_BLUE);
    }

    public final Text darkGreen() {
        return this.color(TextColor.DARK_GREEN);
    }

    public final Text darkAqua() {
        return this.color(TextColor.DARK_AQUA);
    }

    public final Text darkRed() {
        return this.color(TextColor.DARK_RED);
    }

    public final Text darkPurple() {
        return this.color(TextColor.DARK_PURPLE);
    }

    public final Text gold() {
        return this.color(TextColor.GOLD);
    }

    public final Text gray() {
        return this.color(TextColor.GRAY);
    }

    public final Text darkGray() {
        return this.color(TextColor.DARK_GRAY);
    }

    public final Text blue() {
        return this.color(TextColor.BLUE);
    }

    public final Text green() {
        return this.color(TextColor.GREEN);
    }

    public final Text aqua() {
        return this.color(TextColor.AQUA);
    }

    public final Text red() {
        return this.color(TextColor.RED);
    }

    public final Text lightPurple() {
        return this.color(TextColor.LIGHT_PURPLE);
    }

    public final Text yellow() {
        return this.color(TextColor.YELLOW);
    }

    public final Text white() {
        return this.color(TextColor.WHITE);
    }

    public final Text bold(@Nullable Boolean value) {
        this.bold = value;
        return this;
    }

    public final Text bold() {
        return this.bold(true);
    }

    public final Text italic(@Nullable Boolean value) {
        this.italic = value;
        return this;
    }

    public final Text italic() {
        return this.italic(true);
    }

    public final Text underlined(@Nullable Boolean value) {
        this.underlined = value;
        return this;
    }

    public final Text underlined() {
        return this.underlined(true);
    }

    public final Text strikethrough(@Nullable Boolean value) {
        this.strikethrough = value;
        return this;
    }

    public final Text strikethrough() {
        return this.strikethrough(true);
    }

    public final Text obfuscated(@Nullable Boolean value) {
        this.obfuscated = value;
        return this;
    }

    public final Text obfuscated() {
        return this.obfuscated(true);
    }

    public final Text insertion(@Nullable String value) {
        this.insertion = value;
        return this;
    }

    public final Text click(@Nullable String value) {
        this.click = value;
        return this;
    }

    public final Text hover(Object text) {
        this.hover = Text.of(text);
        return this;
    }

    public final Text append(Object sibling) {
        if (this.siblings == null) {
            this.siblings = new LinkedList<Text>();
        }
        this.siblings.add(Text.of(sibling));
        return this;
    }

    public final List<Text> getSiblings() {
        return this.siblings == null ? Collections.emptyList() : this.siblings;
    }

    public final boolean hasSiblings() {
        return this.siblings != null && !this.siblings.isEmpty();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Text) {
            Text t = (Text)obj;
            if (this.color == t.color && this.bold == t.bold && this.italic == t.italic && this.underlined == t.underlined && this.strikethrough == t.strikethrough && this.obfuscated == t.obfuscated) {
                return Objects.equals(this.insertion, t.insertion) && Objects.equals(this.click, t.click) && Objects.equals(this.hover, t.hover) && Objects.equals(this.siblings, t.siblings);
            }
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.color, this.bold, this.italic, this.underlined, this.strikethrough, this.obfuscated, this.insertion, this.click, this.hover, this.siblings});
    }

    public String toString() {
        return this.component().getString();
    }

    @Override
    public int compareTo(Text o) {
        return this.toString().compareTo(this.toString());
    }

    public void write(PacketBuffer buffer) {
        buffer.func_179256_a(this.component());
    }
}

