/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.util;

import dev.latvian.kubejs.script.ScriptFile;
import dev.latvian.kubejs.script.ScriptType;
import dev.latvian.kubejs.util.JSObjectType;
import dev.latvian.kubejs.util.UtilsJS;
import dev.latvian.kubejs.util.WrappedJS;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import jdk.nashorn.internal.runtime.ECMAErrors;
import org.apache.logging.log4j.Logger;

public class ConsoleJS {
    private final ScriptType type;
    private final Logger logger;
    private String group;
    private int lineNumber;
    private boolean muted;

    public ConsoleJS(ScriptType m, Logger log) {
        this.type = m;
        this.logger = log;
        this.group = "";
        this.lineNumber = 0;
    }

    public Logger getLogger() {
        return this.logger;
    }

    protected boolean shouldPrint() {
        return !this.muted;
    }

    public void setMuted(boolean m) {
        this.muted = m;
    }

    public boolean getMuted() {
        return this.muted;
    }

    public void setLineNumber(boolean b) {
        this.lineNumber += b ? 1 : -1;
    }

    private String string(Object object) {
        int ln;
        String s;
        Object o = UtilsJS.wrap(object, JSObjectType.ANY);
        String string = s = o == null || o.getClass().isPrimitive() || o instanceof Boolean || o instanceof String || o instanceof Number || o instanceof WrappedJS ? String.valueOf(o) : o + " [" + o.getClass().getName() + "]";
        if (this.lineNumber == 0 && this.group.isEmpty()) {
            return s;
        }
        StringBuilder builder = new StringBuilder();
        if (this.lineNumber > 0 && (ln = this.getScriptLine()) != -1) {
            ScriptFile f = this.type.manager.get().currentFile;
            if (f != null) {
                builder.append(f.info.location);
            }
            builder.append(':');
            builder.append(this.getScriptLine());
            builder.append(": ");
        }
        builder.append(this.group);
        builder.append(s);
        return builder.toString();
    }

    private String string(Object object, Object ... args) {
        return this.string(String.format(String.valueOf(object), args));
    }

    public void info(Object message) {
        if (this.shouldPrint()) {
            this.logger.info(this.string(message));
        }
    }

    public void infof(String message, Object ... args) {
        if (this.shouldPrint()) {
            this.logger.info(this.string(message, args));
        }
    }

    public void log(Object message) {
        this.info(message);
    }

    public void warn(Object message) {
        if (this.shouldPrint()) {
            this.logger.warn(this.string(message));
        }
    }

    public void warnf(String message, Object ... args) {
        if (this.shouldPrint()) {
            this.logger.warn(this.string(message, args));
        }
    }

    public void error(Object message) {
        if (this.shouldPrint()) {
            this.logger.error(this.string(message));
        }
    }

    public void errorf(String message, Object ... args) {
        if (this.shouldPrint()) {
            this.logger.error(this.string(message, args));
        }
    }

    public void debug(Object message) {
        if (this.shouldPrint()) {
            this.logger.debug(this.string(message));
        }
    }

    public void debugf(String message, Object ... args) {
        if (this.shouldPrint()) {
            this.logger.debug(this.string(message, args));
        }
    }

    public void group() {
        this.group = this.group + "  ";
    }

    public void groupEnd() {
        if (this.group.length() >= 2) {
            this.group = this.group.substring(0, this.group.length() - 2);
        }
    }

    public void trace() {
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        this.info("=== Stack Trace ===");
        for (StackTraceElement element : elements) {
            this.info("=\t" + element);
        }
    }

    public int getScriptLine() {
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if (!ECMAErrors.isScriptFrame((StackTraceElement)element)) continue;
            return element.getLineNumber();
        }
        return -1;
    }

    public void printClass(String className, boolean tree) {
        this.setLineNumber(true);
        try {
            Class<?> c = Class.forName(className);
            Class<?> sc = c.getSuperclass();
            this.info("=== " + c.getName() + " ===");
            this.info("= Parent class =");
            this.info("> " + (sc == null ? "-" : sc.getName()));
            HashMap<String, VarFunc> vars = new HashMap<String, VarFunc>();
            HashMap<String, VarFunc> funcs = new HashMap<String, VarFunc>();
            for (Field field : c.getDeclaredFields()) {
                if ((field.getModifiers() & 1) == 0 || (field.getModifiers() & 0x80) == 0) continue;
                VarFunc f2 = new VarFunc(field.getName(), field.getType());
                f2.flags |= 1;
                if ((field.getModifiers() & 0x10) == 0) {
                    f2.flags |= 2;
                }
                vars.put(f2.name, f2);
            }
            for (AccessibleObject accessibleObject : c.getDeclaredMethods()) {
                if ((((Method)accessibleObject).getModifiers() & 1) == 0 || this.isOverrideMethod((Method)accessibleObject)) continue;
                VarFunc f2 = new VarFunc(((Method)accessibleObject).getName(), ((Method)accessibleObject).getReturnType());
                for (int i = 0; i < ((Method)accessibleObject).getParameterCount(); ++i) {
                    f2.params.add(((Executable)accessibleObject).getParameters()[i].getType());
                }
                if (f2.name.length() >= 4 && f2.name.startsWith("get") && Character.isUpperCase(f2.name.charAt(3)) && f2.params.size() == 0) {
                    String n = Character.toLowerCase(f2.name.charAt(3)) + f2.name.substring(4);
                    VarFunc f0 = (VarFunc)vars.get(n);
                    if (f0 == null) {
                        vars.put(n, new VarFunc(n, f2.type));
                        continue;
                    }
                    if (f0.type.equals(f2.type)) {
                        f0.flags |= 1;
                        continue;
                    }
                }
                funcs.put(f2.name, f2);
            }
            this.info("= Variables and Functions =");
            if (vars.isEmpty() && funcs.isEmpty()) {
                this.info("-");
            } else {
                vars.values().stream().sorted().forEach(f -> this.info("> " + ((f.flags & 2) == 0 ? "val" : "var") + " " + f.name + ": " + this.getSimpleName(f.type)));
                funcs.values().stream().sorted().forEach(f -> this.info("> function " + f.name + "(" + f.params.stream().map(this::getSimpleName).collect(Collectors.joining(", ")) + "): " + this.getSimpleName(f.type)));
            }
            if (tree && sc != null) {
                this.info("");
                this.printClass(sc.getName(), true);
            }
        }
        catch (Throwable ex) {
            this.error("= Error loading class =");
            this.error(ex.toString());
        }
        this.setLineNumber(false);
    }

    public void printClass(String className) {
        this.printClass(className, false);
    }

    private String getSimpleName(Class<?> c) {
        if (c.isPrimitive()) {
            return c.getName();
        }
        String s = c.getName();
        int i = s.lastIndexOf(46);
        s = s.substring(i + 1);
        i = s.lastIndexOf(36);
        s = s.substring(i + 1);
        return s;
    }

    private boolean isOverrideMethod(Method method) throws Throwable {
        return false;
    }

    public void printObject(@Nullable Object o, boolean tree) {
        this.setLineNumber(true);
        if (o == null) {
            this.info("=== null ===");
        } else {
            this.info("=== " + o.getClass().getName() + " ===");
            this.info("= toString() =");
            this.info("> " + o);
            this.info("= hashCode() =");
            this.info("> " + Integer.toHexString(o.hashCode()));
            this.info("");
            this.printClass(o.getClass().getName(), tree);
        }
        this.setLineNumber(false);
    }

    public void printObject(@Nullable Object o) {
        this.printObject(o, false);
    }

    private static final class VarFunc
    implements Comparable<VarFunc> {
        public final String name;
        public final Class<?> type;
        public final ArrayList<Class<?>> params;
        public int flags;

        public VarFunc(String n, Class<?> t) {
            this.name = n;
            this.type = t;
            this.flags = 0;
            this.params = new ArrayList();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VarFunc varFunc = (VarFunc)o;
            return Objects.equals(this.name, varFunc.name) && Objects.equals(this.type, varFunc.type) && Objects.equals(this.flags, varFunc.flags) && Objects.equals(this.params, varFunc.params);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.type, this.flags, this.params);
        }

        @Override
        public int compareTo(VarFunc o) {
            return this.name.compareToIgnoreCase(o.name);
        }
    }
}

