/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import dev.latvian.kubejs.util.Copyable;
import dev.latvian.kubejs.util.JSObjectType;
import dev.latvian.kubejs.util.JsonSerializable;
import dev.latvian.kubejs.util.JsonUtilsJS;
import dev.latvian.kubejs.util.MapJS;
import dev.latvian.kubejs.util.NBTSerializable;
import dev.latvian.kubejs.util.NBTUtilsJS;
import dev.latvian.kubejs.util.UtilsJS;
import dev.latvian.kubejs.util.WrappedJSObject;
import dev.latvian.kubejs.util.WrappedJSObjectChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.CollectionNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.nbt.NumberNBT;

public class ListJS
extends ArrayList<Object>
implements WrappedJSObject,
WrappedJSObjectChangeListener<Object>,
Copyable,
JsonSerializable,
NBTSerializable {
    public WrappedJSObjectChangeListener<ListJS> changeListener;

    @Nullable
    public static ListJS of(@Nullable Object o) {
        Object o1 = UtilsJS.wrap(o, JSObjectType.LIST);
        return o1 instanceof ListJS ? (ListJS)o1 : null;
    }

    public static ListJS orSelf(@Nullable Object o) {
        ListJS l = ListJS.of(o);
        if (l != null) {
            return l;
        }
        ListJS list = new ListJS(1);
        if (o != null) {
            list.add(o);
        }
        return list;
    }

    public static ListJS ofArray(Object array) {
        if (array instanceof Object[]) {
            ListJS list = new ListJS();
            Collections.addAll(list, (Object[])array);
            return list;
        }
        if (array instanceof int[]) {
            return ListJS.of((int[])array);
        }
        if (array instanceof byte[]) {
            return ListJS.of((byte[])array);
        }
        if (array instanceof short[]) {
            return ListJS.of((short[])array);
        }
        if (array instanceof long[]) {
            return ListJS.of((long[])array);
        }
        if (array instanceof float[]) {
            return ListJS.of((float[])array);
        }
        if (array instanceof double[]) {
            return ListJS.of((double[])array);
        }
        if (array instanceof char[]) {
            return ListJS.of((char[])array);
        }
        return new ListJS(0);
    }

    public static ListJS of(byte[] array) {
        ListJS list = new ListJS(array.length);
        for (byte v : array) {
            list.add((Object)v);
        }
        return list;
    }

    public static ListJS of(short[] array) {
        ListJS list = new ListJS(array.length);
        for (short v : array) {
            list.add((Object)v);
        }
        return list;
    }

    public static ListJS of(int[] array) {
        ListJS list = new ListJS(array.length);
        for (int v : array) {
            list.add((Object)v);
        }
        return list;
    }

    public static ListJS of(long[] array) {
        ListJS list = new ListJS(array.length);
        for (long v : array) {
            list.add((Object)v);
        }
        return list;
    }

    public static ListJS of(float[] array) {
        ListJS list = new ListJS(array.length);
        for (float v : array) {
            list.add(Float.valueOf(v));
        }
        return list;
    }

    public static ListJS of(double[] array) {
        ListJS list = new ListJS(array.length);
        for (double v : array) {
            list.add((Object)v);
        }
        return list;
    }

    public static ListJS of(char[] array) {
        ListJS list = new ListJS(array.length);
        for (char v : array) {
            list.add(Character.valueOf(v));
        }
        return list;
    }

    public ListJS() {
        this(0);
    }

    public ListJS(int s) {
        super(s);
    }

    public int getLength() {
        return this.size();
    }

    public void push(Object ... o) {
        if (o.length == 0) {
            return;
        }
        if (o.length == 1) {
            this.add(o[0]);
            return;
        }
        for (int i = 0; i < o.length; ++i) {
            o[i] = UtilsJS.wrap(o[i], JSObjectType.ANY);
            this.setChangeListener(o[i]);
        }
        super.addAll(Arrays.asList(o));
        this.onChanged((Object)null);
    }

    @Nullable
    public Object pop() {
        if (!this.isEmpty()) {
            return this.remove(this.size() - 1);
        }
        return null;
    }

    @Nullable
    public Object shift() {
        if (!this.isEmpty()) {
            return this.remove(0);
        }
        return null;
    }

    public void unshift(Object ... o) {
        if (o.length == 0) {
            return;
        }
        if (o.length == 1) {
            this.add(0, o[0]);
            return;
        }
        for (int i = 0; i < o.length; ++i) {
            o[i] = UtilsJS.wrap(o[i], JSObjectType.ANY);
            this.setChangeListener(o[i]);
        }
        super.addAll(0, Arrays.asList(o));
        this.onChanged((Object)null);
    }

    public void reverse() {
        Collections.reverse(this);
        this.onChanged((Object)null);
    }

    public ListJS filter(Predicate<Object> predicate) {
        ListJS list = new ListJS();
        for (Object o : this) {
            if (!predicate.test(o)) continue;
            list.add(o);
        }
        return list;
    }

    public ListJS map(Function<Object, Object> transformer) {
        ListJS list = new ListJS();
        for (Object o : this) {
            list.add(transformer.apply(o));
        }
        return list;
    }

    public void splice(int pos, int deleteCount, Object ... items) {
        int i;
        for (i = 0; i < deleteCount; ++i) {
            this.remove(pos);
        }
        if (items.length == 0) {
            return;
        }
        if (items.length == 1) {
            this.add(pos, items[0]);
            return;
        }
        for (i = 0; i < items.length; ++i) {
            items[i] = UtilsJS.wrap(items[i], JSObjectType.ANY);
            this.setChangeListener(items[i]);
        }
        super.addAll(pos, Arrays.asList(items));
        this.onChanged((Object)null);
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder();
        this.toString(builder);
        return builder.toString();
    }

    @Override
    public void toString(StringBuilder builder) {
        if (this.isEmpty()) {
            builder.append("[]");
            return;
        }
        builder.append('[');
        for (int i = 0; i < this.size(); ++i) {
            Object o;
            if (i > 0) {
                builder.append(',');
            }
            if ((o = this.get(i)) instanceof WrappedJSObject) {
                ((WrappedJSObject)o).toString(builder);
                continue;
            }
            builder.append(o);
        }
        builder.append(']');
    }

    @Override
    public ListJS copy() {
        ListJS list = new ListJS(this.size());
        for (Object object : this) {
            list.add(UtilsJS.copy(object));
        }
        return list;
    }

    protected boolean setChangeListener(@Nullable Object v) {
        if (v == null) {
            return false;
        }
        if (v instanceof MapJS) {
            ((MapJS)v).changeListener = this::onChanged;
        } else if (v instanceof ListJS) {
            ((ListJS)v).changeListener = this::onChanged;
        }
        return true;
    }

    @Override
    public void onChanged(@Nullable Object o) {
        if (this.changeListener != null) {
            this.changeListener.onChanged(this);
        }
    }

    @Override
    public boolean add(Object value) {
        Object v = UtilsJS.wrap(value, JSObjectType.ANY);
        if (this.setChangeListener(v)) {
            return super.add(v);
        }
        return false;
    }

    @Override
    public void add(int index, Object value) {
        Object v = UtilsJS.wrap(value, JSObjectType.ANY);
        if (this.setChangeListener(v)) {
            super.add(index, v);
        }
    }

    @Override
    public boolean addAll(Collection c) {
        if (c == null || c.isEmpty()) {
            return false;
        }
        Object[] o = c.toArray();
        for (int i = 0; i < o.length; ++i) {
            o[i] = UtilsJS.wrap(o[i], JSObjectType.ANY);
            this.setChangeListener(o[i]);
        }
        super.addAll(Arrays.asList(o));
        this.onChanged((Object)null);
        return true;
    }

    @Override
    public boolean addAll(int index, Collection c) {
        if (c == null || c.isEmpty()) {
            return false;
        }
        Object[] o = c.toArray();
        for (int i = 0; i < o.length; ++i) {
            o[i] = UtilsJS.wrap(o[i], JSObjectType.ANY);
            this.setChangeListener(o[i]);
        }
        super.addAll(index, Arrays.asList(o));
        this.onChanged((Object)null);
        return true;
    }

    @Override
    public Object remove(int index) {
        Object o = super.remove(index);
        this.onChanged((Object)null);
        return o;
    }

    @Override
    public boolean remove(Object o) {
        boolean b = super.remove(o);
        if (b) {
            this.onChanged((Object)null);
        }
        return b;
    }

    @Override
    public void clear() {
        super.clear();
        this.onChanged((Object)null);
    }

    public JsonArray toJson() {
        JsonArray json = new JsonArray();
        for (Object o : this) {
            JsonElement e = JsonUtilsJS.of(o);
            if (e.isJsonNull()) continue;
            json.add(e);
        }
        return json;
    }

    public CollectionNBT<?> toNBT() {
        Object[] array;
        if (this.isEmpty()) {
            return new ListNBT();
        }
        INBT[] values = new INBT[this.size()];
        int s = 0;
        byte commmonId = -1;
        for (Object o : this) {
            values[s] = NBTUtilsJS.toNBT(o);
            if (values[s] == null) continue;
            if (commmonId == -1) {
                commmonId = values[s].func_74732_a();
            } else if (commmonId != values[s].func_74732_a()) {
                commmonId = 0;
            }
            ++s;
        }
        if (commmonId == 3) {
            array = new int[s];
            for (int i = 0; i < s; ++i) {
                array[i] = ((NumberNBT)values[i]).func_150287_d();
            }
            return new IntArrayNBT(array);
        }
        if (commmonId == 1) {
            array = new byte[s];
            for (int i = 0; i < s; ++i) {
                array[i] = ((NumberNBT)values[i]).func_150290_f();
            }
            return new ByteArrayNBT((byte[])array);
        }
        if (commmonId == 4) {
            array = new long[s];
            for (int i = 0; i < s; ++i) {
                array[i] = (int)((NumberNBT)values[i]).func_150291_c();
            }
            return new LongArrayNBT((long[])array);
        }
        if (commmonId == 0 || commmonId == -1) {
            return new ListNBT();
        }
        ListNBT nbt = new ListNBT();
        for (INBT nbt1 : values) {
            if (nbt1 == null) {
                return nbt;
            }
            nbt.add((Object)nbt1);
        }
        return nbt;
    }
}

