/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.kubejs.core.CompoundNBTKJS;
import dev.latvian.kubejs.util.Copyable;
import dev.latvian.kubejs.util.JSObjectType;
import dev.latvian.kubejs.util.JsonSerializable;
import dev.latvian.kubejs.util.JsonUtilsJS;
import dev.latvian.kubejs.util.ListJS;
import dev.latvian.kubejs.util.NBTSerializable;
import dev.latvian.kubejs.util.NBTUtilsJS;
import dev.latvian.kubejs.util.UtilsJS;
import dev.latvian.kubejs.util.WrappedJSObject;
import dev.latvian.kubejs.util.WrappedJSObjectChangeListener;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class MapJS
extends LinkedHashMap<String, Object>
implements WrappedJSObject,
WrappedJSObjectChangeListener<Object>,
Copyable,
JsonSerializable,
NBTSerializable {
    public WrappedJSObjectChangeListener<MapJS> changeListener;

    @Nullable
    public static MapJS of(@Nullable Object o) {
        Object o1 = UtilsJS.wrap(o, JSObjectType.MAP);
        return o1 instanceof MapJS ? (MapJS)o1 : null;
    }

    @Nullable
    public static CompoundNBT nbt(@Nullable Object map) {
        if (map instanceof CompoundNBT) {
            return (CompoundNBT)map;
        }
        MapJS m = MapJS.of(map);
        return m == null ? null : m.toNBT();
    }

    public MapJS() {
        this(0);
    }

    public MapJS(int s) {
        super(s);
    }

    public int getLength() {
        return this.size();
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder builder = new StringBuilder();
        this.toString(builder);
        return builder.toString();
    }

    @Override
    public void toString(StringBuilder builder) {
        if (this.isEmpty()) {
            builder.append("{}");
            return;
        }
        builder.append('{');
        boolean first = true;
        for (Map.Entry entry : this.entrySet()) {
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            builder.append((String)entry.getKey());
            builder.append(':');
            if (entry.getValue() instanceof CharSequence) {
                builder.append('\"');
                builder.append(entry.getValue());
                builder.append('\"');
                continue;
            }
            Object o = entry.getValue();
            if (o instanceof WrappedJSObject) {
                ((WrappedJSObject)o).toString(builder);
                continue;
            }
            builder.append(o);
        }
        builder.append('}');
    }

    @Override
    public MapJS copy() {
        MapJS map = new MapJS(this.size());
        for (Map.Entry entry : this.entrySet()) {
            map.put((String)entry.getKey(), UtilsJS.copy(entry.getValue()));
        }
        return map;
    }

    protected boolean setChangeListener(@Nullable Object v) {
        if (v == null) {
            return false;
        }
        if (v instanceof MapJS) {
            ((MapJS)v).changeListener = this::onChanged;
        } else if (v instanceof ListJS) {
            ((ListJS)v).changeListener = this::onChanged;
        }
        return true;
    }

    @Override
    public void onChanged(@Nullable Object o) {
        if (this.changeListener != null) {
            this.changeListener.onChanged(this);
        }
    }

    @Override
    public Object put(String key, Object value) {
        Object v = UtilsJS.wrap(value, JSObjectType.ANY);
        if (this.setChangeListener(v)) {
            Object o = super.put(key, v);
            this.onChanged((Object)null);
            return o;
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        if (m == null || m.isEmpty()) {
            return;
        }
        for (Map.Entry<String, ?> entry : m.entrySet()) {
            Object v = UtilsJS.wrap(entry.getValue(), JSObjectType.ANY);
            if (!this.setChangeListener(v)) continue;
            super.put(entry.getKey().toString(), v);
        }
        this.onChanged((Object)null);
    }

    @Override
    public void clear() {
        super.clear();
        this.onChanged((Object)null);
    }

    @Override
    @Nullable
    public Object remove(Object key) {
        Object o = super.remove(key);
        if (o != null) {
            this.onChanged((Object)null);
        }
        return o;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        for (Map.Entry entry : this.entrySet()) {
            JsonElement e = JsonUtilsJS.of(entry.getValue());
            if (e.isJsonNull()) continue;
            json.add((String)entry.getKey(), e);
        }
        return json;
    }

    public CompoundNBT toNBT() {
        CompoundNBT nbt = new CompoundNBT();
        ((CompoundNBTKJS)nbt).setTagsKJS(new LinkedHashMap<String, INBT>());
        for (Map.Entry entry : this.entrySet()) {
            INBT nbt1 = NBTUtilsJS.toNBT(entry.getValue());
            if (nbt1 == null) continue;
            nbt.func_218657_a((String)entry.getKey(), nbt1);
        }
        return nbt;
    }

    public MapJS getOrNewMap(String id) {
        MapJS map = MapJS.of(this.get(id));
        if (map == null) {
            map = new MapJS();
            this.put(id, (Object)map);
        }
        return map;
    }

    public ListJS getOrNewList(String id) {
        ListJS list = ListJS.of(this.get(id));
        if (list == null) {
            list = new ListJS();
            this.put(id, (Object)list);
        }
        return list;
    }
}

